% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jackknife.R
\name{SensIAT_jackknife}
\alias{SensIAT_jackknife}
\alias{SensIAT_jackknife_fulldata}
\title{Estimate response with jackknife resampling}
\usage{
SensIAT_jackknife(object, time, ...)

SensIAT_jackknife_fulldata(object, time, ...)
}
\arguments{
\item{object}{A SensIAT_within_group_model object.}

\item{time}{Time points for which to estimate the response.}

\item{...}{currently ignored.}
}
\value{
A \code{tibble} with columns alpha, time, jackknife_mean, and jackknife_var,
where jackknife_mean is the mean of the jackknife estimates and jackknife_var
is the estimated variances of the response at the given time points for the
specified alpha values.
}
\description{
Estimate response with jackknife resampling
}
\section{Functions}{
\itemize{
\item \code{SensIAT_jackknife_fulldata()}: Estimate variance of the treatment effect with jackknife resampling for full data models.

}}
\examples{
\dontrun{
object <-
fit_SensIAT_within_group_model(
    group.data = SensIAT_example_data,
    outcome_modeler = SensIAT_sim_outcome_modeler,
    alpha = c(-0.6, -0.3, 0, 0.3, 0.6),
    id = Subject_ID,
    outcome = Outcome,
    time = Time,
    intensity.args=list(bandwidth = 30),
    knots = c(60,260,460),
    End = 830
)
jackknife.estimates <- SensIAT_jackknife(object, time = c(90, 180, 270, 360, 450))
}
}
