% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelMatrix.R
\name{ModelMatrix}
\alias{ModelMatrix}
\alias{NamesFromModelMatrixInput}
\title{Model matrix from hierarchies and/or a formula}
\usage{
ModelMatrix(
  data,
  hierarchies = NULL,
  formula = NULL,
  inputInOutput = TRUE,
  crossTable = FALSE,
  sparse = TRUE,
  viaOrdinary = FALSE,
  total = "Total",
  removeEmpty = !is.null(formula) & is.null(hierarchies),
  modelMatrix = NULL,
  dimVar = NULL,
  select = NULL,
  ...
)

NamesFromModelMatrixInput(
  data = NULL,
  hierarchies = NULL,
  formula = NULL,
  dimVar = NULL,
  ...
)
}
\arguments{
\item{data}{Matrix or data frame with data containing codes of relevant variables}

\item{hierarchies}{List of hierarchies, which can be converted by \code{\link{AutoHierarchies}}.
Thus, the variables can also be coded by \code{"rowFactor"} or \code{""}, which correspond to using the categories in the data.}

\item{formula}{A model formula}

\item{inputInOutput}{Logical vector (possibly recycled) for each element of hierarchies.
TRUE means that codes from input are included in output. Values corresponding to \code{"rowFactor"} or \code{""} are ignored.}

\item{crossTable}{Cross table in output when TRUE}

\item{sparse}{Sparse matrix in output when TRUE (default)}

\item{viaOrdinary}{When TRUE, output is generated by \code{\link{model.matrix}} or \code{\link[Matrix]{sparse.model.matrix}}.
Since these functions omit a factor level, an empty factor level is first added.}

\item{total}{String(s) used to name totals}

\item{removeEmpty}{When \code{TRUE}, empty columns (only zeros) are not included in output.
Default is \code{TRUE} with formula input without hierarchy and otherwise \code{FALSE} (see details).}

\item{modelMatrix}{The model matrix as input (same as output)}

\item{dimVar}{The main dimensional variables and additional aggregating variables. This parameter can be  useful when hierarchies and formula are unspecified.}

\item{select}{Data frame specifying variable combinations for output
or a named list specifying code selections for each variable (see details).}

\item{...}{Further arguments to  \code{\link{Hierarchies2ModelMatrix}}, \code{\link{Formula2ModelMatrix}} or \code{\link{HierarchiesAndFormula2ModelMatrix}}}
}
\value{
A (sparse) model matrix or a list of two elements (model matrix and cross table)
}
\description{
A common interface to \code{\link{Hierarchies2ModelMatrix}}, \code{\link{Formula2ModelMatrix}} and \code{\link{HierarchiesAndFormula2ModelMatrix}}
}
\details{
The default value of \code{removeEmpty} corresponds to the default settings of the underlying functions.
The functions \code{\link{Hierarchies2ModelMatrix}} and \code{\link{HierarchiesAndFormula2ModelMatrix}}
have \code{removeEmpty} as an explicit parameter with \code{FALSE} as default.
The function \code{\link{Formula2ModelMatrix}} is a wrapper for \code{\link{FormulaSums}},
which has a parameter \code{includeEmpty} with \code{FALSE} as default.
Thus, \code{ModelMatrix} makes a call to \code{Formula2ModelMatrix} with \code{includeEmpty = !removeEmpty}.

\code{NamesFromModelMatrixInput} returns the names of the data columns involved in creating the model matrix.
Note that \code{data} must be non-NULL to convert dimVar as indices to names.

The \code{select} parameter is forwarded to \code{Hierarchies2ModelMatrix} unless \code{removeEmpty = TRUE} is combined with \code{select} as a data frame.
In all other cases, \code{select} is handled outside the underlying functions by making selections in the result.
Empty columns can be added to the model matrix when \code{removeEmpty = FALSE} (with warning).
}
\examples{
# Create some input
z <- SSBtoolsData("sp_emp_withEU")
ageHier <- data.frame(mapsFrom = c("young", "old"), mapsTo = "Total", sign = 1)
geoDimList <- FindDimLists(z[, c("geo", "eu")], total = "Europe")[[1]]

# Small dataset example. Two dimensions.
s <- z[z$geo == "Spain" & z$year != 2016, ]
rownames(s) <- NULL
s

# via Hierarchies2ModelMatrix() and converted to ordinary matrix (not sparse)
ModelMatrix(s, list(age = ageHier, year = ""), sparse = FALSE)

# Hierarchies generated automatically. Then via Hierarchies2ModelMatrix()
ModelMatrix(s[, c(1, 4)])

# via Formula2ModelMatrix()
ModelMatrix(s, formula = ~age + year)

# via model.matrix() after adding empty factor levels
ModelMatrix(s, formula = ~age + year, sparse = FALSE, viaOrdinary = TRUE)

# via sparse.model.matrix() after adding empty factor levels
ModelMatrix(s, formula = ~age + year, viaOrdinary = TRUE)

# via HierarchiesAndFormula2ModelMatrix() and using different data and parameter settings
ModelMatrix(s, list(age = ageHier, geo = geoDimList, year = ""), formula = ~age * geo + year, 
            inputInOutput = FALSE, removeEmpty = TRUE, crossTable = TRUE)
ModelMatrix(s, list(age = ageHier, geo = geoDimList, year = ""), formula = ~age * geo + year, 
            inputInOutput = c(TRUE, FALSE), removeEmpty = FALSE, crossTable = TRUE)
ModelMatrix(z, list(age = ageHier, geo = geoDimList, year = ""), formula = ~age * year + geo, 
            inputInOutput = c(FALSE, TRUE), crossTable = TRUE)
            
# via Hierarchies2ModelMatrix() using unnamed list element. See AutoHierarchies.             
colnames(ModelMatrix(z, list(age = ageHier, c(Europe = "geo", Allyears = "year", "eu"))))
colnames(ModelMatrix(z, list(age = ageHier, c("geo", "year", "eu")), total = c("t1", "t2")))

# Example using the select parameter as a data frame
select <- data.frame(age = c("Total", "young", "old"), geo = c("EU", "nonEU", "Spain"))
ModelMatrix(z, list(age = ageHier, geo = geoDimList), 
            select = select, crossTable = TRUE)$crossTable
            
# Examples using the select parameter as a list
ModelMatrix(z, list(age = ageHier, geo = geoDimList), inputInOutput = FALSE, 
            select = list(geo = c("nonEU", "Portugal")), crossTable = TRUE)$crossTable
ModelMatrix(z, list(age = ageHier, geo = geoDimList), 
            select = list(geo = c("nonEU", "Portugal"), age = c("Total", "young")), 
            crossTable = TRUE)$crossTable

# Using NAomit parameter avalable in Formula2ModelMatrix()
s$age[1] <- NA
ModelMatrix(s, formula = ~age + year)
ModelMatrix(s, formula = ~age + year, NAomit = FALSE)

}
\seealso{
\link{formula_utils}
}
\author{
Øyvind Langsrud
}
