# objective: Test that BalancedAccuracy
# implemented in {SLmetrics} is aligned with
# target functions.

testthat::test_that(
  desc = "Test `baccuracy()`-function", code = {

    testthat::skip_on_cran()

    # 0) construct Balanced Accuracy
    # wrapper
    wrapped_baccuracy <- function(
      actual,
      predicted,
      adjust,
      w = NULL) {
        if (is.null(w)) {
          baccuracy(
            actual     = actual,
            predicted  = predicted,
            adjust     = adjust
          )
        } else {
          weighted.baccuracy(
            actual     = actual,
            predicted  = predicted,
            w          = w,
            adjust     = adjust
          )
        }
      }
    
    for (balanced in c(FALSE, TRUE)) {

      # 1) generate class
      # values
      actual    <- create_factor(balanced = balanced)
      predicted <- create_factor(balanced = balanced)
      w         <- runif(n = length(actual))

      for (weighted in c(TRUE, FALSE)) {
      
        # 2) test that the are 
        # equal to target values
        for (adjust in c(TRUE, FALSE)) {
          
          # 2.1) generate sensible 
          # label information
          info <- paste(
            "Balanced = ", balanced,
            "Adjusted = ", adjust,
            "Weighted = ", weighted
          )

          # 2.2) generate score
          # from {slmetrics}
          score <- wrapped_baccuracy(
            actual     = actual,
            predicted  = predicted,
            w          = if (weighted) w else NULL,
            adjust     = adjust
          )

          # 2.3) test that the values
          # are sensible the values 
          # can be NA
          testthat::expect_true(is.numeric(score), info = info)
          testthat::expect_true(length(score) == 1, info = info)

          # 2.4) test that the values
          # are equal to target value

          # 2.4.1) calculate py_score
          py_score <- py_baccuracy(
            actual    = actual,
            predicted = predicted,
            adjust    = adjust,
            w          = if (weighted) w else NULL
          )

          # 2.4.2) test for equality
          testthat::expect_true(
            object = set_equal(
              current = as.numeric(score),
              target  = as.numeric(py_score)
            ),
            info = info
          )


        }

      }

    }
  }
)