% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.SLOPE}
\alias{plot.SLOPE}
\title{Plot coefficients}
\usage{
\method{plot}{SLOPE}(
  x,
  intercept = FALSE,
  x_variable = c("alpha", "deviance_ratio", "step"),
  ...
)
}
\arguments{
\item{x}{an object of class \code{"SLOPE"}}

\item{intercept}{whether to plot the intercept}

\item{x_variable}{what to plot on the x axis. \code{"alpha"} plots
the scaling parameter for the sequence, \code{"deviance_ratio"} plots
the fraction of deviance explained, and \code{"step"} plots step number.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
An object of class \code{"ggplot"}, which will be plotted on the
current device unless stored in a variable.
}
\description{
Plot the fitted model's regression
coefficients along the regularization path.
}
\examples{
fit <- SLOPE(heart$x, heart$y)
plot(fit)
}
\seealso{
\code{\link[=SLOPE]{SLOPE()}}, \code{\link[=plotDiagnostics]{plotDiagnostics()}}

Other SLOPE-methods: 
\code{\link{coef.SLOPE}()},
\code{\link{deviance.SLOPE}()},
\code{\link{predict.SLOPE}()},
\code{\link{print.SLOPE}()},
\code{\link{score}()}
}
\concept{SLOPE-methods}
