% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HCRs.R
\name{HCR_segment}
\alias{HCR_segment}
\title{Segmented harvest control rules}
\usage{
HCR_segment(
  Assessment,
  reps = 1,
  OCP_type = c("SSB_SSB0", "SSB_SSBMSY", "SSB_dSSB0", "F_FMSY", "F_F01", "F_FSPR"),
  Ftarget_type = c("FMSY", "F01", "Fmax", "FSPR", "abs"),
  OCP = c(0.1, 0.4),
  relF = c(0, 1),
  SPR_OCP,
  SPR_targ,
  ...
)
}
\arguments{
\item{Assessment}{An object of class \linkS4class{Assessment} with estimates of
FMSY or UMSY, vulnerable biomass, and spawning biomass depletion in terminal year.}

\item{reps}{The number of stochastic samples of the TAC recommendation.}

\item{OCP_type}{The type of operational control points (OCPs) for the harvest control rule used to determine the reduction in F.
See below.}

\item{Ftarget_type}{The type of F used for the target fishing mortality rate. See below.}

\item{OCP}{Numeric vector of operational control points for the HCR (in increasing order).}

\item{relF}{Numeric vector of Ftarget corresponding to the values in \code{OCP}.}

\item{SPR_OCP}{The value of spawning potential ratio for the OCP if \code{OCP_type = "F_FSPR"}. By default, 0.4 (F40\%).}

\item{SPR_targ}{The target value of spawning potential ratio if \code{Ftarget_type = "FSPR"}. By default, 0.4 (F40\%).}

\item{...}{Miscellaneous arguments.}
}
\value{
An object of class \linkS4class{Rec} with the TAC recommendation.
}
\description{
A linear segmented output control rule where the target F (used for the TAC recommendation)
is a function of an operational control point (OCP) such as spawning depletion or spawning biomass.
The segments of the HCR are specified by arguments \code{OCP} and \code{relF}. Beyond the range of \code{OCP}, the response will be flat.
\link{HCR_ramp} uses \code{HCR_segment} with two control points.
}
\details{
The catch advice is calculated using the catch equation of the corresponding
assessment. See \code{Assessment@forecast$catch_eq}, a function that returns the catch advice for a specified \code{Ftarget}.

\emph{Operational control points (OCP_type)}

The following are the available options for harvest control rule inputs, and the source of those values
in the \linkS4class{Assessment} object:

\itemize{
\item \strong{Default} \code{"SSB_SSB0"}: Spawning depletion. Uses the last value in  \code{Assessment@SSB_SSB0} vector.
\item \code{"SSB_SSBMSY"}: Spawning biomass relative to MSY. Uses the last value in \code{Assessment@SSB_SSBMSY} vector.
\item \code{"SSB_dSSB0"}: Dynamic depletion (SSB relative to the historical reconstructed biomass with F = 0). Uses the last value in
\code{Assessment@SSB/Assessment@TMB_report$dynamic_SSB0}.
\item \code{"F_FMSY"}: Fishing mortality relative to MSY. Uses the last value in \code{Assessment@F_FMSY}.
\item \code{"F_F01"}: Fishing mortality relative to F_0.1 (yield per recruit), calculated from the data frame in
\code{Assessment@forecast[["per_recruit"]]}.
\item \code{"F_FSPR"}: Fishing mortality relative to F_SPR\% (the F that produces the spawning potential ratio specified in
\code{"SPR_OCP"}, calculated from the data frame in \code{Assessment@forecast[["per_recruit"]]}.
}

\emph{Fishing mortality target (Ftarget_type)}

The type of F for which the corresponding catch is calculated in the HCR is specified here. The source of those values
in the \linkS4class{Assessment} object is specified:

\itemize{
\item \strong{Default} \code{"FMSY"}: Fishing mortality relative to MSY. Uses the value in \code{Assessment@FMSY}.
\item \code{"F01"}: Fishing mortality relative to F_0.1 (yield per recruit), calculated from the data frame in
\code{Assessment@forecast[["per_recruit"]]}.
\item \code{"Fmax"}: Fishing mortality relative to F_max (maximizing yield per recruit), calculated from the data frame in
\code{Assessment@forecast[["per_recruit"]]}.
\item \code{"FSPR"}: Fishing mortality relative to F_SPR\% (the F that produces the spawning potential ratio specified in
\code{"SPR_targ"}, calculated from data frame in \code{Assessment@forecast[["per_recruit"]]}.
\item \code{"abs"}: Fishing mortality is independent of any model output and is explicitly specified in \code{relF}.
}
}
\examples{
# This is an MP with a 40-10 harvest control rule (using FMSY)
DD_40_10 <- make_MP(DD_TMB, HCR_segment, OCP_type = "SSB_SSB0", OCP = c(0.1, 0.4), relF = c(0, 1)) 
#' 
# This is an MP with a 40-10 harvest control rule with a maximum F of 0.1
DD_40_10 <- make_MP(DD_TMB, HCR_segment, OCP_type = "SSB_SSB0", 
                    Ftarget_type = "abs", OCP = c(0.1, 0.4), relF = c(0, 0.1)) 
}
\author{
Q. Huynh
}
