% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Response.R
\name{Response}
\alias{Response}
\title{Creates Response object}
\description{
Creates response object.
}
\examples{
# init response
rs = Response$new()
# set body media type
rs$set_content_type("text/plain")
# set body content
rs$set_body("OK")
# set response status code
rs$set_status_code(200L)
# print response
rs

# init response
rs = Response$new()
# static file path
file_path = system.file("DESCRIPTION", package = "RestRserve")
# get last file modification timestamp
file_mtime = file.mtime(file_path)
# set body
rs$set_body(c("file" = file_path))
# set content type
rs$set_content_type("text/plain")
# set current timestamp
rs$set_date()
# set 'last-modified' header
rs$set_header("Last-Modified", as(file_mtime, "HTTPDate"))
# print response
rs

}
\seealso{
\link{Request} \link{Application}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{body}}{Response body.\cr
If it is a named character with a name \code{file} or \code{tmpfile}
then the value is considered as a path to a file and content oh this file
is served as body. The latter will be deleted once served.}

\item{\code{content_type}}{Response body content (media) type. Will be translated
to \code{Content-type} header.}

\item{\code{headers}}{Response headers.}

\item{\code{status_code}}{Response HTTP status code.}

\item{\code{cookies}}{Response cookies. Will be translated to \code{Set-Cookie} headers.}

\item{\code{context}}{Environment to store any data. Can be used in middlewares.}

\item{\code{encode}}{Function to encode body for specific content.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{status}}{Paste together status code and description.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Response-new}{\code{Response$new()}}
\item \href{#method-Response-reset}{\code{Response$reset()}}
\item \href{#method-Response-set_content_type}{\code{Response$set_content_type()}}
\item \href{#method-Response-set_status_code}{\code{Response$set_status_code()}}
\item \href{#method-Response-has_header}{\code{Response$has_header()}}
\item \href{#method-Response-get_header}{\code{Response$get_header()}}
\item \href{#method-Response-set_header}{\code{Response$set_header()}}
\item \href{#method-Response-delete_header}{\code{Response$delete_header()}}
\item \href{#method-Response-append_header}{\code{Response$append_header()}}
\item \href{#method-Response-set_date}{\code{Response$set_date()}}
\item \href{#method-Response-unset_date}{\code{Response$unset_date()}}
\item \href{#method-Response-set_cookie}{\code{Response$set_cookie()}}
\item \href{#method-Response-unset_cookie}{\code{Response$unset_cookie()}}
\item \href{#method-Response-set_body}{\code{Response$set_body()}}
\item \href{#method-Response-set_response}{\code{Response$set_response()}}
\item \href{#method-Response-print}{\code{Response$print()}}
\item \href{#method-Response-clone}{\code{Response$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Response-new"></a>}}
\if{latex}{\out{\hypertarget{method-Response-new}{}}}
\subsection{Method \code{new()}}{
Creates Response object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$new(
  body = NULL,
  content_type = "text/plain",
  headers = list(Server = getOption("RestRserve.headers.server")),
  status_code = 200L,
  encode = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{body}}{Response body.}

\item{\code{content_type}}{Response body content (media) type.}

\item{\code{headers}}{Response headers.}

\item{\code{status_code}}{Response status code.}

\item{\code{encode}}{Function to encode body for specific content.}

\item{\code{...}}{Not used at this moment.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Response-reset"></a>}}
\if{latex}{\out{\hypertarget{method-Response-reset}{}}}
\subsection{Method \code{reset()}}{
Resets response object. This is not useful for end user, but useful for
RestRserve internals - resetting R6 class is much faster then initialize it.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$reset()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Response-set_content_type"></a>}}
\if{latex}{\out{\hypertarget{method-Response-set_content_type}{}}}
\subsection{Method \code{set_content_type()}}{
Set content type for response body.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$set_content_type(content_type = "text/plain")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{content_type}}{Response body content (media) type.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Response-set_status_code"></a>}}
\if{latex}{\out{\hypertarget{method-Response-set_status_code}{}}}
\subsection{Method \code{set_status_code()}}{
Set HTTP status code for response. See \href{https://developer.mozilla.org/en-US/docs/Web/HTTP/Status}{docs on MDN}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$set_status_code(code)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{code}}{Status code as integer number.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Response-has_header"></a>}}
\if{latex}{\out{\hypertarget{method-Response-has_header}{}}}
\subsection{Method \code{has_header()}}{
Determine whether or not the response header exists.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$has_header(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Header field name.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Logical value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Response-get_header"></a>}}
\if{latex}{\out{\hypertarget{method-Response-get_header}{}}}
\subsection{Method \code{get_header()}}{
Get HTTP response header value. If requested header is empty returns \code{default}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$get_header(name, default = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Header field name.}

\item{\code{default}}{Default value if header does not exists.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Header field values (character string).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Response-set_header"></a>}}
\if{latex}{\out{\hypertarget{method-Response-set_header}{}}}
\subsection{Method \code{set_header()}}{
Set HTTP response header. \code{Content-type} and \code{Content-length} headers not
allowed (use \code{content_type} field instead).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$set_header(name, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Header field name.}

\item{\code{value}}{Header field value.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Response-delete_header"></a>}}
\if{latex}{\out{\hypertarget{method-Response-delete_header}{}}}
\subsection{Method \code{delete_header()}}{
Unset HTTP response header.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$delete_header(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Header field name.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Logical value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Response-append_header"></a>}}
\if{latex}{\out{\hypertarget{method-Response-append_header}{}}}
\subsection{Method \code{append_header()}}{
Append HTTP response header. If header exists \verb{,} separator will be used.
Don't use this method to set cookie (use \code{set_cookie} method instead).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$append_header(name, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Header field name.}

\item{\code{value}}{Header field value.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Response-set_date"></a>}}
\if{latex}{\out{\hypertarget{method-Response-set_date}{}}}
\subsection{Method \code{set_date()}}{
Set \code{Date} HTTP header. See \href{https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Date}{docs on MDN}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$set_date(dtm = Sys.time())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dtm}}{POSIXct value.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Response-unset_date"></a>}}
\if{latex}{\out{\hypertarget{method-Response-unset_date}{}}}
\subsection{Method \code{unset_date()}}{
Unset \code{Date} HTTP header.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$unset_date()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Logical value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Response-set_cookie"></a>}}
\if{latex}{\out{\hypertarget{method-Response-set_cookie}{}}}
\subsection{Method \code{set_cookie()}}{
Set cookie. See \href{https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Set-Cookie}{docs on MDN}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$set_cookie(
  name,
  value,
  expires = NULL,
  max_age = NULL,
  domain = NULL,
  path = NULL,
  secure = NULL,
  http_only = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Cookie name.}

\item{\code{value}}{Cookie value.}

\item{\code{expires}}{Cookie expires date and time (POSIXct).}

\item{\code{max_age}}{Max cookie age (integer).}

\item{\code{domain}}{Cookie domain.}

\item{\code{path}}{Cookie path.}

\item{\code{secure}}{Cookie secure flag.}

\item{\code{http_only}}{Cookie HTTP only flag.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Response-unset_cookie"></a>}}
\if{latex}{\out{\hypertarget{method-Response-unset_cookie}{}}}
\subsection{Method \code{unset_cookie()}}{
Unset cookie with given name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$unset_cookie(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Cookie name.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Logical value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Response-set_body"></a>}}
\if{latex}{\out{\hypertarget{method-Response-set_body}{}}}
\subsection{Method \code{set_body()}}{
Set response body.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$set_body(body)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{body}}{Response body.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Response-set_response"></a>}}
\if{latex}{\out{\hypertarget{method-Response-set_response}{}}}
\subsection{Method \code{set_response()}}{
Set response fields.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$set_response(
  status_code,
  body = NULL,
  content_type = self$content_type
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{status_code}}{Response HTTP status code.}

\item{\code{body}}{Response body.}

\item{\code{content_type}}{content_type Response body content (media) type.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Response-print"></a>}}
\if{latex}{\out{\hypertarget{method-Response-print}{}}}
\subsection{Method \code{print()}}{
Print method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Response-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Response-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
