# ReplicationSuccess

Provides utilities for the design and analysis of replication studies.
Features both traditional methods based on statistical significance and
more recent methods such as the sceptical p-value. Also provides related
methods including the harmonic mean chi-squared test and intrinsic credibility.
Contains datasets from four large-scale replication projects.

## Installation

CRAN version:
```r
install.packages("ReplicationSuccess")
```

Development version from github with latest developments:
```r
devtools::install_github(repo = "crsuzh/ReplicationSuccess")
```

## Links


- Website (pkgdown): https://crsuzh.github.io/ReplicationSuccess/
- CRAN repository: https://cran.r-project.org/web/packages/ReplicationSuccess/

## Introduction in vignette

To access the vignette from R use:
```r
library("ReplicationSuccess")
vignette("ReplicationSuccess")
```


## Publications

  - Held, L. (2019). The assessment of intrinsic credibility and a new argument
    for *p* < 0.005. *Royal Society Open Science*, 6(3):181534.
    <https://doi.org/10.1098/rsos.181534>
  
  - Held, L. (2020). A new standard for the analysis and design of replication
    studies (with discussion). *Journal of the Royal Statistical Society: Series
    A (Statistics in Society)*. 183(2):431-448.
    <https://doi.org/10.1111/rssa.12493>
  
  - Held, L. (2020). The harmonic mean chi-squared test to substantiate
    scientific findings. *Journal of the Royal Statistical Society: Series C
    (Applied Statistics)*, 69(3):697-708. <https://doi.org/10.1111/rssc.12410>

  - Pawel, S., Held, L. (2020). Probabilistic forecasting of replication
    studies. PLoS ONE 15(4):e0231416.
    <https://doi.org/10.1371/journal.pone.0231416>
    
  - Micheloud, C., Held, L. (2021). Power Calculations for Replication Studies.
    *Statistical Science*. 37(3):369–379. <https://doi.org/10.1214/21-STS828>
    
  - Held, L., Micheloud, C., Pawel, S. (2022). The assessment of replication
    success based on relative effect size. *The Annals of Applied Statistics*.
    16:706–720. <https://doi.org/10.1214/21-AOAS1502>
  
  - Micheloud, C., Balabdaoui, F., Held, L. (2023). Assessing replicability with
    the sceptical *p*-value: Type-I error control and sample size planning.
    *Statistica Neerlandica*. <https://doi.org/10.1111/stan.12312>
