% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gridfun.R
\name{gridfun}
\alias{gridfun}
\title{Specifies grid for the calculation of the halfspace location depths}
\usage{
gridfun(D, grid.size, k = 4)
}
\arguments{
\item{D}{Data set with rows representing the individuals and
columns representing the features. In the case of three
dimensions, the colnames of D must be c("x", "y", "z").}

\item{grid.size}{Number of grid points in each dimension.}

\item{k}{Number of dimensions of the grid. Needs only be specified
if D has more than columns.}
}
\value{
A list containing the following elements:
\describe{
\item{\emph{H}}{The k-dimensional array.}
}
In the case of a 3-dimensional array, additional elements are:
\describe{
\item{\emph{grid.x, grid.y, grid.z}}{The coordinates of the grid points at each dimension.}
}
In the case that the array has more than three dimensions, additional elements are:
\describe{
\item{\emph{grid.k}}{A matrix with the coordinates of the grid. Row represents dimensions and columns represent grid points.}
}
}
\description{
Specifies a k-dimensional array as grid for the calculation of the
halfspace location depths.
}
\details{
D must have at least three columns. If D has three columns,
automatically a 3-dimensional grid is generated. If D has more
than three columns, k must be specified.
}
\seealso{
For more information, please refer to the package's documentation and the tutorial: \url{https://software.klausjung-lab.de/}.
}
\author{
Jochen Kruppa, Klaus Jung
}
