% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_confrontation_report.R
\name{format_confrontation_report_md}
\alias{format_confrontation_report_md}
\title{Format confrontation report in markdown format}
\usage{
format_confrontation_report_md(
  cr,
  title = "Model",
  level = 0,
  numbered = TRUE,
  bgSuccess = "green",
  txSuccess = "black",
  bgFailure = "red",
  txFailure = "white",
  bgMessage = "#FFBB33",
  txMessage = "white"
)
}
\arguments{
\item{cr}{the confrontation report from \link{confront_data}}

\item{title}{a character with a single value corresponding to the report}

\item{level}{rmarkdown level in document hierarchy (default:0 ==> highest).
It should be an integer between 0 and 4.}

\item{numbered}{a logical. If TRUE (default) the sections are part of
document numbering.}

\item{bgSuccess}{background color for SUCCESS}

\item{txSuccess}{text color for SUCCESS}

\item{bgFailure}{background color for FAILURE}

\item{txFailure}{text color for FAILURE}

\item{bgMessage}{background color for a warning message}

\item{txMessage}{text color for a warning message}
}
\description{
Format confrontation report in markdown format
}
\examples{
## Read the model ----
hpo_from_sql <- read_SQL_data_model(
   system.file("examples/HPO-model.sql", package="ReDaMoR")
)
## Confront to data ----
confrontation_report <- confront_data(
   hpo_from_sql,
   path=list.files(
      system.file("examples/HPO-subset", package="ReDaMoR"),
      full.names=TRUE
   ),
   verbose=FALSE,
   returnData=TRUE
)
## Show the report in console ----
format_confrontation_report(confrontation_report) \%>\% cat()
## Format the report using markdown ----
format_confrontation_report_md(confrontation_report) \%>\% cat()
}
