% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rcurvep-package.R
\docType{package}
\name{Rcurvep-package}
\alias{Rcurvep}
\alias{Rcurvep-package}
\title{Rcurvep: Concentration-Response Data Analysis using Curvep}
\description{
An R interface for processing concentration-response datasets using Curvep, a response noise filtering algorithm. The algorithm was described in the publications (Sedykh A et al. (2011) \doi{10.1289/ehp.1002476} and Sedykh A (2016) \doi{10.1007/978-1-4939-6346-1_14}). Other parametric fitting approaches (e.g., Hill equation) are also adopted for ease of comparison. 3-parameter Hill equation from 'tcpl' package (Filer D et al., \doi{10.1093/bioinformatics/btw680}) and 4-parameter Hill equation from Curve Class2 approach (Wang Y et al., \doi{10.2174/1875397301004010057}) are available. Also, methods for calculating the confidence interval around the activity metrics are also provided. The methods are based on the bootstrap approach to simulate the datasets (Hsieh J-H et al. \doi{10.1093/toxsci/kfy258}). The simulated datasets can be used to derive the baseline noise threshold in an assay endpoint. This threshold is critical in the toxicological studies to derive the point-of-departure (POD).
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/moggces/Rcurvep}
  \item Report bugs at \url{https://github.com/moggces/Rcurvep/issues}
}

}
\author{
\strong{Maintainer}: Jui-Hua Hsieh \email{juihua.hsieh@gmail.com} (\href{https://orcid.org/0000-0003-1620-1571}{ORCID})

Authors:
\itemize{
  \item Alexander Sedykh
  \item Tongan Zhao
}

Other contributors:
\itemize{
  \item Fred Parham [contributor]
  \item Yuhong Wang [contributor]
  \item Ruili Huang [contributor]
}

}
\keyword{internal}
