% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.r
\name{msgpack_read}
\alias{msgpack_read}
\alias{msgpackRead}
\title{'MsgPack' read}
\usage{
msgpack_read(file, simplify = F, mode = "auto", nbytes = 16777216)

msgpackRead(file, simplify = F, mode = "auto", nbytes = 16777216)
}
\arguments{
\item{file}{A connection, or a string describing the file or pipe to write to, depending on the mode.}

\item{simplify}{Passed to msgpack_unpack.  Default: FALSE.}

\item{mode}{One of "auto", "file", "gzip" or "pipe".  If "auto", detects based on the file string (any space == pipe, ".gz" == gzip, file otherwise).  Ignored if file is a connection.}

\item{nbytes}{If reading from a pipe or gzip, how many bytes to read at a time.  Default: 16777216}
}
\description{
A helper function to de-serialize an object read from a file or a connection.
}
\examples{
tmp <- tempfile(fileext=".gz")
msgpack_write(1:10, file=tmp)
x <- msgpack_read(tmp, simplify=TRUE)
}
