% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats-walk-summary.R
\name{summarize_walks}
\alias{summarize_walks}
\alias{summarise_walks}
\title{Summarize Walks Data}
\usage{
summarize_walks(.data, .value, .group_var)

summarise_walks(.data, .value, .group_var)
}
\arguments{
\item{.data}{A data frame or tibble containing random walk data.}

\item{.value}{A column name (unquoted) representing the value to summarize.}

\item{.group_var}{A column name (unquoted) representing the grouping variable.}
}
\value{
A tibble containing the summarized statistics for each group,
including mean, median, range, quantiles, variance, standard deviation,
and more.
}
\description{
Summarizes random walk data by computing statistical measures.
}
\details{
This function requires that the input data frame contains a
column named 'walk_number' and that the value to summarize is provided.
It computes statistics such as mean, median, variance, and quantiles
for the specified value variable. #' This function summarizes a data frame
containing random walk data by computing various statistical measures for a
specified value variable, grouped by a specified grouping variable. It checks
for necessary attributes and ensures that the data frame is structured correctly.
}
\examples{
library(dplyr)

# Example data frame
walk_data <- random_normal_walk(.initial_value = 100)

# Summarize the walks
summarize_walks(walk_data, cum_sum, walk_number) |>
 glimpse()
summarize_walks(walk_data, y) |>
  glimpse()

# Example with missing value variable
# summarize_walks(walk_data, NULL, group) # This will trigger an error.

}
\author{
Steven P. Sanderson II, MPH
}
\concept{Statistic Functions}
