% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pEllipticInt.R
\name{pEllipticInt}
\alias{pEllipticInt}
\title{Partial elliptic integral}
\source{
Van de Vel, H. (1969). \emph{On the series expansion method for Computing 
    incomplete elliptic integrals of the first and second kinds}, 
      Math. Comp. 23, 61-69.
}
\usage{
pEllipticInt(x, saxes, n = 5)
}
\arguments{
\item{x}{the \eqn{x}-coordinate.}

\item{saxes}{a \eqn{(2 \times 1)} vector of the length of the ellipse semi-axes.}

\item{n}{the number of iterations.}
}
\value{
Return the partial elliptic integral.
}
\description{
Partial elliptic integral
}
\examples{
# Ellipse with semi-axes: a = 5, b= 2
saxes <- c(5,2)

# 1 iteration
pEllipticInt(3,saxes,n=1)
# 5 iterations
pEllipticInt(3,saxes,n=5)
# 10 iterations
pEllipticInt(3,saxes,n=10)
}
\seealso{
\code{\link{arcLengthEllipse}}
}
