<!-- README.md is generated from README.Rmd. Please edit that file -->

`R6P` <img src="https://raw.githubusercontent.com/tidylab/R6P/master/pkgdown/logo.png" align="right" height="75"/>
==================================================================================================================

<!-- badges: start -->

[![CRAN
status](https://www.r-pkg.org/badges/version/R6P)](https://CRAN.R-project.org/package=R6P)
[![R build
status](https://github.com/tidylab/R6P/workflows/R-CMD-check/badge.svg)](https://github.com/tidylab/R6P/actions)
[![codecov](https://codecov.io/gh/tidylab/R6P/branch/master/graph/badge.svg?token=U6FL5N32FL)](https://codecov.io/gh/tidylab/R6P)

<!-- badges: end -->

Introduction
------------

Build robust and maintainable software with object-oriented design
patterns in R. Design patterns abstract and present in neat,
well-defined components and interfaces the experience of many software
designers and architects over many years of solving similar problems.
These are solutions that have withstood the test of time with respect to
re-usability, flexibility, and maintainability. ‘R6P’ provides abstract
base classes with examples for a few known design patterns. The patterns
were selected by their applicability to analytic projects in R. Using
these patterns in R projects have proven effective in dealing with the
complexity that data-driven applications possess.

This package is based on the work of Gamma1995, and Fowler2002.

Installation
------------

You can install the released version of R6P from
[CRAN](https://CRAN.R-project.org) with:

    install.packages("R6P")

And the development version from [GitHub](https://github.com/) with:

    # install.packages("devtools")
    devtools::install_github("tidylab/R6P")

References
----------

Fowler, Martin. 2002. *Patterns of enterprise application architecture*.
Addison-Wesley Longman Publishing Co., Inc.

Gamma, Erich, Richard Helm, Ralph Johnson, and John Vlissides. 1995.
*Design patterns: elements of reusable object-oriented software*.
Pearson Education India.
