% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbms.R
\name{gigwa_get_samples}
\alias{gigwa_get_samples}
\title{Get the Samples List of the Current Active GIGWA Run}
\usage{
gigwa_get_samples()
}
\value{
A vector of all samples in the selected run.
}
\description{
This function retrieves the samples list of the current active run
as configured in the internal state object using the `gigwa_set_run()` function.
}
\examples{
if (interactive()) {
  # Configure your GIGWA connection
  set_qbms_config("https://gigwa.southgreen.fr/gigwa/", 
                  time_out = 300, engine = "gigwa", no_auth = TRUE)

  # Select a database by name
  gigwa_set_db("Sorghum-JGI_v1")

  # Select a project by name
  gigwa_set_project("Nelson_et_al_2011")
  
  # Select a specific run by name
  gigwa_set_run("run1")
  
  # Get a list of all samples in the selected run
  samples <- gigwa_get_samples()
}
}
\seealso{
\code{\link{set_qbms_config}}, \code{\link{gigwa_set_run}}
}
\author{
Khaled Al-Shamaa, \email{k.el-shamaa@cgiar.org}
}
