% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extr_outs.R
\name{extr_outs}
\alias{extr_outs}
\title{Extracting outputs from \code{\link[=bayes_met]{bayes_met()}} objects}
\usage{
extr_outs(
  data,
  trait,
  model,
  probs = c(0.025, 0.975),
  check.stan.diag = TRUE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{data}{A data frame containing the observations}

\item{trait}{A character representing the name of the column that
corresponds to the analysed trait}

\item{model}{An object containing the Bayesian model fitted using \code{rstan}}

\item{probs}{A vector with two elements representing the probabilities
(in decimal scale) that will be considered for computing the quantiles.}

\item{check.stan.diag}{A logical value indicating whether the function should
extract some diagnostic using native \code{rstan} functions.}

\item{verbose}{A logical value. If \code{TRUE}, the function will indicate the
completed steps. Defaults to \code{FALSE}}

\item{...}{Passed to \code{\link[rstan:stan_plot_diagnostics]{rstan::stan_diag()}}}
}
\value{
The function returns a list with:
\itemize{
\item \code{post} : a list with the posterior of the effects, and the data
generated by the model
\item \code{map} : a list with the maximum posterior values of each effect
\item \code{ppcheck} : a matrix containing the p-values of maximum, minimum,
median, mean and standard deviation; effective number of parameters, WAIC2
value, Rhat and effective sample size.
\item \code{plots} : a list with three types of ggplots: histograms, trace plots and density
plots. These will be available for all effects declared at the \code{effects} argument.
\item \code{stan_plots}: If \code{check.stan.diag = TRUE}, a list with plots generated by \code{\link[rstan:stan_plot_diagnostics]{rstan::stan_diag()}}
}
}
\description{
This function extracts outputs of the Bayesian model fitted
using \code{\link[=bayes_met]{bayes_met()}}, and provides some diagnostics about the model
}
\details{
More details about the usage of \code{extr_outs}, as well as the other function of
the \code{ProbBreed} package can be found at \url{https://saulo-chaves.github.io/ProbBreed_site/}.
}
\examples{
\donttest{
mod = bayes_met(data = maize,
                gen = "Hybrid",
                loc = "Location",
                repl = c("Rep", "Block"),
                year = NULL,
                reg = 'Region',
                res.het = FALSE,
                trait = 'GY',
                iter = 6000, cores = 4, chains = 4)

outs = extr_outs(data = maize, trait = "GY", model = mod,
                 probs = c(0.05, 0.95),
                 check.stan.diag = TRUE,
                 verbose = TRUE)
                 }
}
\seealso{
\code{\link[rstan:stan_plot_diagnostics]{rstan::stan_diag()}}, \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}, \code{\link[rstan:check_hmc_diagnostics]{rstan::check_hmc_diagnostics()}}
}
