% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foo.R
\name{spatial.pred.lm.ps}
\alias{spatial.pred.lm.ps}
\title{Spatial predictions for the geostatistical Linear Gaussian model using plug-in of ML estimates}
\usage{
spatial.pred.lm.ps(
  object,
  grid.pred = NULL,
  predictors = NULL,
  predictors.intensity = NULL,
  control.mcmc = NULL,
  target = 3,
  type = "marginal",
  quantiles = NULL,
  standard.errors = FALSE,
  messages = TRUE,
  return.samples = FALSE
)
}
\arguments{
\item{object}{an object of class "PrevMap" obtained as result of a call to \code{\link{linear.model.MLE}}.}

\item{grid.pred}{a matrix of prediction locations. Default is \code{grid.pred=NULL}, in which case the grid used to approximate the intractable integral in the log-Gaussian Cox process model is used for prediction.}

\item{predictors}{a data frame of the values of the explanatory variables at each of the locations in \code{grid.pred}, for the response variable model; each column correspond to a variable and each row to a location. \bold{Warning:} the names of the columns in the data frame must match those in the data used to fit the model. Default is \code{predictors=NULL} for models with only an intercept.}

\item{predictors.intensity}{a data frame of the values of the explanatory variables at each of the locations in \code{grid.pred}, for the log-Gaussian Cox process model; each column correspond to a variable and each row to a location. \bold{Warning:} the names of the columns in the data frame must match those in the data used to fit the model. Default is \code{predictors=NULL} for models with only an intercept.}

\item{control.mcmc}{output from \code{\link{control.mcmc.MCML}} which defined the control parameters of the Monte Carlo Markv chain algorithm.}

\item{target}{an integeter indicating the predictive target: \code{target=1} if the predictive target is the linear predictor of the response; \code{target=2} is the predictive target is the sampling intensity of the preferentially sampled data; \code{target=3} if both of the above are the predictive targets. Default is \code{target=3}.}

\item{type}{a character indicating the type of spatial predictions for \code{target=1}: \code{type="marginal"} for marginal predictions or \code{type="joint"} for joint predictions. Default is \code{type="marginal"}. Note that predictions for the sampling intensity (\code{target=2}) are always joint.}

\item{quantiles}{a vector of quantiles used to summarise the spatial predictions.}

\item{standard.errors}{logical; if \code{standard.errors=TRUE}, then standard errors for each \code{scale.predictions} are returned. Default is \code{standard.errors=FALSE}.}

\item{messages}{logical; if \code{messages=TRUE} then status messages are printed on the screen (or output device) while the function is running. Default is \code{messages=TRUE}.}

\item{return.samples}{logical; if \code{return.samples=TRUE} a matrix of the predictive samples for the prediction target (as specified in \code{target}) are returned in the output.}
}
\value{
A "pred.PrevMap.ps" object list with the following components: \code{response} (if \code{target=1} or \code{target=3}) and \code{intensity} (if \code{target=2} pr \code{target=3}).
\code{grid.pred} prediction locations.
Each of the components \code{intensity} and \code{response} is a list with the following components:

\code{predictions}: a vector of the predictive mean for the corresponding target.

\code{standard.errors}: a vector of prediction standard errors (if \code{standard.errors=TRUE}).

\code{quantiles}: a matrix of quantiles of the resulting predictions with each column corresponding to a quantile specified through the argument \code{quantiles}.

\code{samples}: a matrix corresponding to the predictive samples of the predictive target (only if \code{return.samples=TRUE}), with each row corresponding to a samples and column to a prediction location.
In the case of a model with a mix of preferential and non-preferential data, if \code{target=1} or \code{target=3}, each of the above components will be a list with two components,
namely \code{preferential} and \code{non.preferential}, associated with \code{response}.
}
\description{
This function performs spatial prediction, fixing the model parameters at the maximum likelihood estimates of a linear geostatistical model.
}
\author{
Emanuele Giorgi \email{e.giorgi@lancaster.ac.uk}
}
