% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PrInDTregAll.R
\name{PrInDTregAll}
\alias{PrInDTregAll}
\title{Regression tree based on all observations}
\usage{
PrInDTregAll(datain, regname, ctestv=NA, conf.level=0.95)
}
\arguments{
\item{datain}{Input data frame with class factor variable 'classname' and the\cr
influential variables, which need to be factors or numericals (transform logicals and character variables to factors)}

\item{regname}{name of regressand variable (character)}

\item{ctestv}{Vector of character strings of forbidden split results;\cr
{see function \code{\link{PrInDT}} for details.}\cr
If no restrictions exist, the default = NA is used.}

\item{conf.level}{(1 - significance level) in function \code{ctree} (numerical, > 0 and <= 1);\cr
default = 0.95}
}
\value{
\describe{
\item{treeall}{tree based on all observations}
\item{R2All}{goodness of fit of 'treeall' based on all observations}
\item{interpAll}{criterion of interpretability of 'treeall' (TRUE / FALSE)}
}
}
\description{
Regression tree based on the full sample; interpretability is checked (see 'ctestv').\cr
The relationship between the target variable 'regname' and all other factor and numerical variables
in the data frame 'datain' is modeled based on all observations. \cr
}
\details{
Standard output can be produced by means of \code{print(name)} or just \code{ name } as well as \code{plot(name)} where 'name' is the output data 
frame of the function.
}
\examples{
data <- PrInDT::data_vowel
data <- na.omit(data)
ctestv <- 'vowel_maximum_pitch <= 320'
outreg <- PrInDTregAll(data,"target",ctestv)
outreg
plot(outreg)

}
