% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/walk_forward.R
\name{run_walk_forward}
\alias{run_walk_forward}
\title{Walk-Forward Optimization Analysis}
\usage{
run_walk_forward(
  prices,
  grid,
  builder,
  metric = NULL,
  is_periods = 52,
  oos_periods = 13,
  step = NULL,
  warmup_periods = 0,
  verbose = FALSE,
  light_mode = TRUE,
  precompute_all = TRUE,
  builder_args = list(),
  n_cores = 1
)
}
\arguments{
\item{prices}{Data frame with Date column and symbol columns}

\item{grid}{Data frame OR named list; each row/combination is a parameter set}

\item{builder}{Function(prices, params, ...) -> weights data.frame (Date + assets)}

\item{metric}{Function(backtest_result) -> scalar score (higher is better).
Defaults to \code{metric_sharpe} if omitted/NULL.}

\item{is_periods}{Integer, number of in-sample periods}

\item{oos_periods}{Integer, number of out-of-sample periods}

\item{step}{Integer, step size for rolling windows (default = oos_periods)}

\item{warmup_periods}{Integer, warmup periods appended before each OOS}

\item{verbose}{Logical, print progress}

\item{light_mode}{Logical, passed to run_param_grid (kept for compatibility)}

\item{precompute_all}{Logical, precompute indicators once and slice per window}

\item{builder_args}{List, extra args passed to builder (e.g., indicator_cache)}

\item{n_cores}{Integer (kept for API compatibility; ignored here)}
}
\value{
An object of class \code{wf_optimization_result}.
}
\description{
Runs rolling IS/OOS optimization, reselects params each window, and
backtests OOS performance (optionally with warmup tails).
}
