% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/black_litterman.R
\name{black.litterman}
\alias{black.litterman}
\title{Black Litterman Estimates}
\usage{
black.litterman(R, P, Mu = NULL, Sigma = NULL, Views = NULL)
}
\arguments{
\item{R}{returns}

\item{P}{a K x N pick matrix}

\item{Mu}{vector of length N of the prior expected values. The sample mean
is used if \code{Mu=NULL}.}

\item{Sigma}{an N x N matrix of the prior covariance matrix. The sample 
covariance is used if \code{Sigma=NULL}.}

\item{Views}{a vector of length K of the views}
}
\value{
\itemize{
  \item{BLMu:}{ posterior expected values}
  \item{BLSigma:}{ posterior covariance matrix}
}
}
\description{
Compute the Black Litterman estimate of moments for the posterior normal.
}
\note{
This function is largely based on the work of Xavier Valls to port
the matlab code of Attilio Meucci to \R as documented in the Meucci package.
}
\references{
A. Meucci - "Exercises in Advanced Risk and Portfolio Management" \url{http://symmys.com/node/170}.
}
\seealso{
\code{\link{BlackLittermanFormula}}
}
\author{
Ross Bennett, Xavier Valls
}
