% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{load_example_seurat}
\alias{load_example_seurat}
\title{Example Seurat Object for PopComm Package}
\format{
A \code{\link[Seurat]{Seurat}} object with the following slots:
\describe{
\item{assays}{RNA count matrix normalized by log1p.}
\item{meta.data}{Dataframe containing metadata columns:
\itemize{
\item \code{sample}: Sample identifier (e.g., "sample1", "sample2").
\item \code{broad.cell.type}: Cell type annotations (e.g., "Cardiac", "Fibroblast").
}
}
\item{reductions}{PCA and UMAP embeddings for visualization.}
}
}
\source{
Subset of snRNA-seq data analyzed in our study,
processed via standard workflow (see manuscript for details).
Full dataset available at \href{https://zenodo.org/}{Zenodo}
(DOI: 10.XXXX/zenodo.XXXXX).
}
\usage{
load_example_seurat()
}
\value{
A \code{\link[Seurat]{Seurat}} object containing example single-cell RNA-seq data.
If the download fails, the function returns \code{NULL}.
}
\description{
A preprocessed Seurat object containing single-cell RNA sequencing data for demonstration
and testing purposes across functions in the PopComm package. The object includes normalized
expression data, metadata with sample and cell type annotations, and basic preprocessing
steps (e.g., dimensionality reduction).
}
\keyword{internal}
