% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ellipse.R
\name{LownerJohnEllipse}
\alias{LownerJohnEllipse}
\title{Löwner-John ellipse (ellipse hull)}
\usage{
LownerJohnEllipse(pts)
}
\arguments{
\item{pts}{the points in a two-columns matrix (one point per row); at least
three distinct points}
}
\value{
An \code{Ellipse} object.
}
\description{
Minimum area ellipse containing a set of points.
}
\examples{
\donttest{pts <- cbind(rnorm(30, sd=2), rnorm(30))
ell <- LownerJohnEllipse(pts)
box <- ell$boundingbox()
plot(NULL, asp = 1, xlim = box$x, ylim = box$y, xlab = NA, ylab = NA)
draw(ell, col = "seaShell")
points(pts, pch = 19)
all(apply(pts, 1, ell$contains)) # should be TRUE}
}
