% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Return.locScaleRob.R
\name{Return.locScaleRob}
\alias{Return.locScaleRob}
\title{Robust Filter for Time Series Returns}
\usage{
Return.locScaleRob(R, alpha.robust = 0.05, normal.efficiency = 0.99, ...)
}
\arguments{
\item{R}{Data of returns for assets or portfolios.}

\item{alpha.robust}{Tuning parameter for the robust filter.}

\item{normal.efficiency}{Normal efficiency for robust filter.}

\item{\dots}{any other passthrough parameters}
}
\value{
A vector of the cleaned data.
}
\description{
\code{Return.locScaleRob} returns the data after passing through a robust location and scale filter.
}
\examples{
# Loading data from PerformanceAnalytics
data(edhec, package = "PerformanceAnalytics")
class(edhec)
# Changing the data colnames
names(edhec) = c("CA", "CTA", "DIS", "EM", "EMN",
                 "ED", "FIA", "GM", "LS", "MA",
                 "RV", "SS", "FOF")
# Cleaning the returns time series for manager data
outRob <- Return.locScaleRob(edhec$CA)

}
\author{
Xin Chen, \email{chenx26@uw.edu}

Anthony-Alexander Christidis, \email{anthony.christidis@stat.ubc.ca}
}
