% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_data.R
\name{prepare_data}
\alias{prepare_data}
\title{prepare_data
The calculation of point estimates and standard errors first requires the calculation of a variety of different weights, parameters, and indicator variables. This function prepares the data within PanelEstimate() such that the estimates can be calculated easily. In practical terms, the function calls the lower level helpers to calculate W_its and D_its as described in Imai et al. (2023) and merges those results together with the original data to facilitate calculations.}
\usage{
prepare_data(
  data.in,
  lead,
  sets.att = NULL,
  sets.atc = NULL,
  qoi.in,
  dependent.variable
)
}
\arguments{
\item{data.in}{data.frame: the data to be used in the analysis}

\item{lead}{See PanelMatch() documentation}

\item{sets.att}{matched.set object containing ATT or ART matched sets.}

\item{sets.atc}{matched.set object containing ATC matched sets.}

\item{qoi.in}{See PanelMatch() documentation}

\item{dependent.variable}{string specifying the outcome/dependent variable.}
}
\value{
data.frame with the results of the lower level calculations
}
\description{
prepare_data
The calculation of point estimates and standard errors first requires the calculation of a variety of different weights, parameters, and indicator variables. This function prepares the data within PanelEstimate() such that the estimates can be calculated easily. In practical terms, the function calls the lower level helpers to calculate W_its and D_its as described in Imai et al. (2023) and merges those results together with the original data to facilitate calculations.
}
\keyword{internal}
