% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_estimates.R
\name{calculate_estimates}
\alias{calculate_estimates}
\title{calculate_estimates}
\usage{
calculate_estimates(
  qoi.in,
  data.in,
  lead,
  number.iterations,
  att.treated.unit.ids,
  atc.treated.unit.ids,
  outcome.variable,
  unit.id.variable,
  confidence.level,
  att.sets,
  atc.sets,
  placebo.test = FALSE,
  lag,
  se.method,
  pooled = FALSE,
  parallel = FALSE,
  num.cores = 1
)
}
\arguments{
\item{qoi.in}{String specifying qoi}

\item{data.in}{data.frame object with the data}

\item{lead}{integer specifying lead window}

\item{number.iterations}{integer. specifies number of bootstrap iterations}

\item{att.treated.unit.ids}{Integer vector specifying the treated units for the att or art}

\item{atc.treated.unit.ids}{Integer vector specifying the "treated" units under the atc definition}

\item{outcome.variable}{string specifying the name of the outcome variable}

\item{unit.id.variable}{string specifying the name of the unit id variable}

\item{confidence.level}{double. specifies confidence level for confidence interval}

\item{att.sets}{matched.set object specifying the att or art sets}

\item{atc.sets}{matched.set object specifying the atc sets}

\item{lag}{integer vector specifying size of the lag.}

\item{se.method}{string specifying which method should be used for standard error calculation}

\item{pooled}{bool. specifies whether or not estimates should be calculated for each lead period, or pooled across all lead periods}

\item{parallel}{bool. Specifies whether or not parallelization should be used}

\item{num.cores}{Integer. specifies how many cores to use for parallelization}
}
\value{
Returns PanelEstimate object.
}
\description{
Mid-level function that helps with estimation process. Calls lower level helper functions
}
\keyword{internal}
