% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phenology.R
\name{phenology}
\alias{phenology}
\title{Calculate phenological events}
\usage{
phenology(
  x,
  model,
  parametrisation = NULL,
  year = NULL,
  hatch = NULL,
  return_date = TRUE,
  ...
)
}
\arguments{
\item{x}{SpatRaster list/dataframe (tmean, tmax, tmin) - numeric - with time
attribute/date column}

\item{model}{name of model - character}

\item{parametrisation}{name of parametrisation - character}

\item{year}{year for prognosis - numeric}

\item{hatch}{SpatRaster - logical - with time attribute TRUE/FALSE
hatch/no_hatch}

\item{return_date}{TRUE/FALSE defines output -> see value}

\item{...}{parameter to change default values. (i.e. ldt = 3.5)}
}
\value{
If return_date is TRUE returns single layered SpatRaster with time
serial number (first occurence of phenological event).
If return_date is FALSE returns a one layer per day SpatRaster type logical
with phenological event occurred/not TRUE/FALSE.
}
\description{
Using daily mean or min and max temperature data, the function
calculates the temperature-dependent development stages of OPM or the bud
stages (bud swelling and leaf unfolding) of its host tree
\emph{Quercus robur}.

The default settings correspond to the model described by Halbig et al. 2024.
Additional parametrizations are provided but have not yet been tested.

Halbig et al. 2024
It follows 4 different steps:
\itemize{
\item a) Calculating and summing up cold days or frost days.
(Cold days are defined as days with a mean temperature below ldt
(lower development threshold), while frost days are all days with a min
temperature below ldt).
Hatch dependent development stages need a hatch raster (hatch happened
1 or not 0) for each day
\item b) Calculating degree days with the
single sine method of Baskerville & Emin, 1969 or simple summing up tmean
temperatures over ldt.
\item c) Calculating the needed
sum of effective temperatures for the development stage
\item d) Comparing degree days with the needed sum of effective temperatures
}
}
\examples{
## SpatRaster
srl <- load_test()

# Calculating bud swelling for our raster example
budswelling <- phenology(srl,
                         model = "budswelling",
                         parametrisation = "quercus_robur_clone256_type1",
                         year = 2020)

}
\references{
Halbig et al. 2014: Halbig, P., Stelzer, A. S., Baier, P., Pennerstorfer,
J., Delb, H., & Schopf, A. (2024). PHENTHAUproc–An early warning and decision
support system for hazard assessment and control of oak processionary moth
(Thaumetopoea processionea). Forest Ecology and Management, 552, 121525 \cr
Baskerville & Emin 1969: Baskerville, G. L., & Emin, P. (1969). Rapid
estimation of heat accumulation from maximum and minimum temperatures.
Ecology, 50(3), 514-517. (\url{doi:10.2307/1933912}) \cr
Menzel 1997: Menzel, A. (1997). Phänologie von Waldbäumen unter sich
ändernden Klimabedingungen: Auswertung der Beobachtungen in den
internationalen phänologischen Gärten und Möglichkeiten der Modellierung von
Phänodaten. Frank. \cr
}
\seealso{
Other Main: 
\code{\link{get_legend}()},
\code{\link{mortality}()},
\code{\link{parameter}()},
\code{\link{phenthau}()}
}
\author{
Bachfischer Lorenz, Department of Forest Protection FVA (2024)
\email{lorenz.bachfischer@posteo.de}
}
\concept{Main}
