% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Metabolic_Equations.R
\name{get_bmr}
\alias{get_bmr}
\title{Retrieve estimated basal metabolic rate for an individual}
\usage{
get_bmr(Sex = c("M", "F"), Ht = NULL, Wt, Age, verbose = FALSE,
  RER = NULL, equation = c("ht_wt", "wt", "both"), kcal_table = c("Lusk",
  "Peronnet", "both"), method = c("Schofield", "FAO", "both"),
  MJ_conversion = c("thermochemical", "dry", "convenience", "all"),
  kcal_conversion = 5)
}
\arguments{
\item{Sex}{The individual's sex}

\item{Ht}{The individual's height, in meters}

\item{Wt}{The individual's weight, in kilograms}

\item{Age}{The individual's age, in years}

\item{verbose}{Logical. Should processing updates be printed?}

\item{RER}{numeric. The respiratory exchange ratio}

\item{equation}{The equation to apply}

\item{kcal_table}{The table to reference for converting kilocalories to
oxygen consumption. See \code{\link{get_kcal_vo2_conversion}}}

\item{method}{The calculation method to use}

\item{MJ_conversion}{The value to use for converting megajoules to
kilocalories. Defaults to thermochemical.}

\item{kcal_conversion}{numeric. If RER is NULL (default), the factor to use
for converting kilocalories to oxygen consumption}
}
\description{
Retrieve estimated basal metabolic rate for an individual
}
\examples{

# Get BMR for an imaginary 900-year-old person (Age is only
# used to determine which equations to use, in this case the
# equations for someone older than 60)

get_bmr(
  Sex = "M", Ht = 1.5, Wt = 80, Age = 900, equation = "both",
  method = "both", RER = 0.865, kcal_table = "both",
  MJ_conversion = c("all")
)

get_bmr(
  Sex = "M", Ht = 1.5, Wt = 80, Age = 900, MJ_conversion = "all",
  kcal_conversion = 4.86
)

get_bmr(
  Sex = "M", Ht = 1.5, Wt = 80, Age = 900, method = "FAO",
  kcal_conversion = 4.86
)

}
\references{
Schofield, W. N. (1985). Predicting basal metabolic rate, new standards and
review of previous work. \emph{Human nutrition. Clinical nutrition}, 39,
5-41.
}
