% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roccaWhistleCalcs.R
\name{roccaWhistleCalcs}
\alias{roccaWhistleCalcs}
\title{Calculate a Set of Measurements for Whistles}
\usage{
roccaWhistleCalcs(data)
}
\arguments{
\item{data}{a list that must have \code{freq} the whistle contour stored as a
vector of FFT bin frequencies in hertz, and \code{time} the time in seconds
at each bin.}
}
\value{
A list with 50 calculated ROCCA parameters, each item in the list will
  only have 1 entry so that this can easily be converted to a data frame.
}
\description{
Calculate a set of measurements from a whistle contour. All
  calculations following ROCCA method from Julie and Michael Oswald, as
  implemented in Pamguard and detailed in Oswald et al (2007) <doi:10.1121/1.2743157>
}
\examples{

data(testWhistle)
roccaWhistleCalcs(testWhistle)

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
