% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matchEnvData.R
\name{matchEnvData,AcousticEvent-method}
\alias{matchEnvData,AcousticEvent-method}
\alias{matchEnvData,AcousticStudy-method}
\title{Match Environmental Data to an AcousticStudy Object}
\usage{
\S4method{matchEnvData}{AcousticEvent}(
  data,
  nc = NULL,
  var = NULL,
  buffer = c(0, 0, 0),
  FUN = c(mean),
  fileName = NULL,
  progress = TRUE,
  depth = 0,
  ...
)

\S4method{matchEnvData}{AcousticStudy}(
  data,
  nc = NULL,
  var = NULL,
  buffer = c(0, 0, 0),
  FUN = c(mean),
  fileName = NULL,
  progress = TRUE,
  depth = 0,
  ...
)
}
\arguments{
\item{data}{an \linkS4class{AcousticStudy} or \linkS4class{AcousticEvent} object
that must have GPS data added to it using the \link{addGps} functions}

\item{nc}{name of a netcdf file, ERDDAP dataset id, or an edinfo object}

\item{var}{(optional) vector of variable names}

\item{buffer}{vector of Longitude, Latitude, and Time (seconds) to buffer around
each datapoint. All values within the buffer will be used to report the mean,
median, and standard deviation}

\item{FUN}{a vector or list of functions to apply to the data. Default is to apply
mean, median, and standard deviation calculations}

\item{fileName}{(optional) file name to save downloaded nc file to. If not provided,
then no nc files will be stored, instead small temporary files will be downloaded
and then deleted. This can be much faster, but means that the data will need to be
downloaded again in the future. If \code{fileName} is provided, then the function
will attempt to download a single nc file covering the entire range of your data.
If your data spans a large amount of time and space this can be problematic.}

\item{progress}{logical flag to show progress bar}

\item{depth}{depth values (meters) to use for matching, overrides any \code{Depth} column
in the data or can be used to specify desired depth range when not present in data.
Variables will be summarised over the range of these depth values. \code{NULL}
uses all available depth values}

\item{\dots}{other parameters to pass to \link[PAMmisc]{ncToData}}
}
\value{
original data object with environmental data added to the \code{ancillary} slot
  of each event. Complete data will be stored in \code{ancillary(data)$environmental},
  and the mean of each downloaded variable will be stored in \code{ancillary(data)$measures}
  so that it can be exported for modeling. For each event the coordinates associated with
  the earliest UTC value in that event are used to match
}
\description{
Extracts all variables from a netcdf file matching Longitude,
  Latitude, and UTC coordinates of the start of each AcousticEvent object.
  Matched values are stored in the "ancillary" slot of each event
}
\examples{

data(exStudy)
nc <- system.file('extdata', 'sst.nc', package='PAMmisc')
# suppressing warnings because nc coordinates dont align with this data,
# function warns of possible coordinate mismatch
exStudy <- suppressWarnings(matchEnvData(exStudy, nc=nc, progress=FALSE))
str(ancillary(exStudy[[1]])$environmental)
ancillary(exStudy[[1]])$measures

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
