% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removeNote.R
\name{removeNote}
\alias{removeNote}
\title{removeNote}
\usage{
removeNote(x, index)
}
\arguments{
\item{x}{An \linkS4class{AcousticStudy} or \linkS4class{AcousticEvent} object}

\item{index}{The index of the note to remove, order matches the output of \link{getNotes}}
}
\value{
For \code{addNote}, the same data as \code{x}, with notes added.
  For \code{getNotes}, a list of all notes present in \code{x}
}
\description{
Remove a note added with \link{addNote}
}
\examples{

data(exStudy)
exStudy <- addNote(exStudy, to='study', label='Note1',
                   note='My first note for this study')
exStudy <- addNote(exStudy, to='event', evNum=1:2, label='Note2',
                   note='A note for the first two events')
exStudy
removeNote(exStudy, 1)
removeNote(exStudy, 2)
removeNote(exStudy, 3)

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
