% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateICI.R
\name{calculateICI}
\alias{calculateICI}
\alias{calculateICI,AcousticStudy-method}
\alias{calculateICI,AcousticEvent-method}
\alias{getICI}
\title{Calculate Inter-Click Interval}
\usage{
calculateICI(
  x,
  time = c("UTC", "peakTime"),
  callType = c("click", "whistle", "cepstrum", "gpl"),
  verbose = TRUE,
  ...
)

\S4method{calculateICI}{AcousticStudy}(
  x,
  time = c("UTC", "peakTime"),
  callType = c("click", "whistle", "cepstrum", "gpl"),
  verbose = TRUE,
  ...
)

\S4method{calculateICI}{AcousticEvent}(
  x,
  time = c("UTC", "peakTime"),
  callType = c("click", "whistle", "cepstrum", "gpl"),
  verbose = TRUE,
  ...
)

getICI(x, type = c("value", "data"))
}
\arguments{
\item{x}{a \linkS4class{AcousticStudy} object, a list of \linkS4class{AcousticEvent}
objects, or a single \linkS4class{AcousticEvent} object}

\item{time}{the time measurement to use. \code{start} will use the \code{UTC} value,
\code{peak} will use the \code{peakTime} value if present (currently present in
\code{standardClickCalcs}, this is the time of the peak of the waveform)}

\item{callType}{the call type to calculate ICI for, usually this is \code{click}
but also allows users to specify \code{whistle} or \code{cepstrum} to calculate this
using other detector data}

\item{verbose}{logical flag to print messages}

\item{\dots}{not currently used}

\item{type}{the type of data to return, one of 'value' or 'data'. 'value' returns
the single ICI value for each detector, 'data' returns all the individual ICI values
used to calculate the number returned by 'value'}
}
\value{
the same object as \code{x}, with ICI data added to the "ancillary" slot
  of each AcousticEvent. Two items will be added. $ici contains all of the
  individual inter-click intervals used to calculate the ICI, as well as an "All"
  ICI using all the combined data. $measures will also have a ICI measurement added
  for each detector, this will be the single modal value. Data in the $measures spot
  can be exported easily to modeling algorithms. \code{getICI} will just return either
  the values stored in $measures for \code{type = 'value'} or a dataframe of the
  individual ICI values used to calculate these (with columns indicating separate Channels,
  eventIds, and detectorNames) for \code{type = 'data'}
}
\description{
Calculate inter-click interval for click data
}
\details{
Calculates the ICI for each individual detector and across all detectors.
  ICI calculation is done by ordering all individual detections by time, then taking
  the difference between consecutive detections and approximating the mode value.
}
\examples{

# setting up example data
data(exStudy)
exStudy <- calculateICI(exStudy)
# each event has its ICI data stored separately, these are 0
# because there is only a single click in this event
ancillary(exStudy[[1]])$ici
# also saves it in measures that will get exported for modeling
ancillary(exStudy[[1]])$measures

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
