% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addCalibration.R
\name{addCalibration}
\alias{addCalibration}
\alias{applyCalibration}
\title{Add a Calibration File to a PAMpalSettings Object}
\usage{
addCalibration(
  pps,
  calFile = NULL,
  module = "ClickDetector",
  calName = NULL,
  all = FALSE,
  units = NULL
)

applyCalibration(pps, module = "ClickDetector", all = FALSE)
}
\arguments{
\item{pps}{a \linkS4class{PAMpalSettings} object to add a database to}

\item{calFile}{a calibration file name. Must be csv format with two columns.
The first column must be the frequency (in Hz), and the second column must be the
sensitivity (in dB), and the columns should be labeled \code{Frequency}
and \code{Sensitivity}. Can also be supplied as a dataframe in which
case the \code{calName} argument should also be set}

\item{module}{the Pamguard module type this calibration should be applied to,
for now this is only for ClickDetector modules. This is left as an option
for future-proofing purposes but should not be needed.}

\item{calName}{the name to assign to the calibration function, defaults to
the file name and only needs to be set if supplying a dataframe instead of
a csv file}

\item{all}{logical flag whether or not to apply calibration to all functions
without asking individually, recommended to stay as \code{FALSE}}

\item{units}{a number from 1 to 3 specifying the units of the calibration file,
number corresponds to dB re V/uPa, uPa/Counts, or uPa/FullScale respectively.
A NULL (default) or other value will prompt user to select units.}
}
\value{
the same \linkS4class{PAMpalSettings} object as pps, with the calibration
  function added to the \code{calibration} slot.
}
\description{
Adds a new calibration function to the "calibration" slot
  of a PAMpalSettings object. Interactively asks user to supply
  file and other parameters if not supplied.
}
\details{
When adding a calibration, you will be asked what units your calibration
  value is in. The wave clips stored by Pamguard are values from -1 to 1, so if
  your calibration is expecting different units then this needs to be accounted
  for in order to get an accurate SPL value. For V / uPa you must know the voltage
  range of your recording equipment, and for calibrations expecting Count data you
  must know the bit rate of your recordings. If your calibration is already relative
  to full-scale, then nothing needs to be adjusted. If you don't know the units of
  your calibration and you are only interested in relative dB levels, then you can
  select the Full-Scale options.

  The calibration function created takes frequency (in Hz) as input and
  outputs the associated dB value that needs to be added to correct the
  power spectrum of a signal. If the input is a matrix or dataframe, the first
  column is assumed to be frequency.
}
\examples{

pps <- new('PAMpalSettings')
calFile <- system.file('extdata', 'calibration.csv', package='PAMpal')
pps <- addCalibration(pps, calFile, all = TRUE, units=3)
calClick <- function(data, calibration=NULL) {
    standardClickCalcs(data, calibration=calibration, filterfrom_khz = 0)
}
pps <- addFunction(pps, calClick, module = 'ClickDetector')
pps <- applyCalibration(pps, all=TRUE)
pps

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
