% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addBinaries.R
\name{addBinaries}
\alias{addBinaries}
\title{Add Binaries to a PAMpalSettings Object}
\usage{
addBinaries(pps, folder = NULL, verbose = TRUE)
}
\arguments{
\item{pps}{a \linkS4class{PAMpalSettings} object to add binary files to}

\item{folder}{a folder of binaries to add, all subfolders will also be added}

\item{verbose}{logical flag to show messages}
}
\value{
the same \linkS4class{PAMpalSettings} object as pps, with the binary
  files contained in \code{folder} added to the "binaries" slot. Only
  binary files for Click Detector and WhistlesMoans modules will be added,
  since these are the only types PAMpal currently knows how to process
}
\description{
Adds more binary files to the "binaries" slot of a
  PAMpalSettings object. Interactively asks user to supply
  folder location if not provided.
}
\examples{

# not recommended to create PPS like this, for example only
pps <- new('PAMpalSettings')
binFolder <- system.file('extdata', 'Binaries', package='PAMpal')
pps <- addBinaries(pps, binFolder)
pps

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
