% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeClickWave.R
\name{writeClickWave}
\alias{writeClickWave}
\alias{createClickWave}
\title{Write Click Waveform}
\usage{
writeClickWave(
  fileName,
  outDir,
  signalLength,
  clickLength,
  clicksPerSecond,
  frequency,
  sampleRate,
  silence = c(0, 0),
  gainFactor = 0.1
)

createClickWave(
  signalLength,
  clickLength,
  clicksPerSecond,
  frequency,
  sampleRate,
  silence = c(0, 0),
  gainFactor = 0.1
)
}
\arguments{
\item{fileName}{name of the file to write. If missing, the file be named
usign signalLength, clickLength, clicksPerSecond, frequency, and sampleRate}

\item{outDir}{directory to write wave files to}

\item{signalLength}{length of signal to create in seconds}

\item{clickLength}{length of each click in microseconds}

\item{clicksPerSecond}{number of clicks per second}

\item{frequency}{frequency of the clicks}

\item{sampleRate}{sample rate for the wave file to create}

\item{silence}{silence to pad before and after signal in seconds}

\item{gainFactor}{scaling factor between 0 and 1. Low numbers are recommended (default 0.1)}
}
\value{
\code{writeClickWave} invisibly returns the file name, \code{createClickWave}
  returns a \link[tuneR]{Wave} class object
}
\description{
Write a wave file for a synthesized delphinid click
}
\details{
This code is based on Matlab code by Julie Oswald (2004). Clicks are
  simulated as an exponentially damped sinusoid.
}
\examples{

tmpFile <- file.path(tempdir(), 'tempWav.wav')
writeClickWave(tmpFile, signalLength = 1, clickLength = 100, clicksPerSecond = 200,
               frequency = 30000, sampleRate = 100000)
file.remove(tmpFile)
clickWave <- createClickWave(signalLength = 1, clickLength = 100, clicksPerSecond = 200,
                             frequency = 30e3, sampleRate = 100e3)

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
