% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raytrace.R
\name{raytrace}
\alias{raytrace}
\title{Raytrace Through a Soundspeed Profile}
\usage{
raytrace(x0, z0, theta0, tt, zz, cc, plot = TRUE, progress = FALSE)
}
\arguments{
\item{x0}{starting horizontal coordinate in meters}

\item{z0}{starting vertical coordinate in meters}

\item{theta0}{starting angle(s) of ray in degrees}

\item{tt}{max travel time of ray in seconds}

\item{zz}{vertical coordinates of sound speed profile (positive values are down)}

\item{cc}{sound speed measurements at \code{zz} locations, meters / second}

\item{plot}{logical flag to plot. Can be a vector of length two to individually
select plotting one of the two plots generated}

\item{progress}{logical flag to show progress bar}
}
\value{
A list with four elements: \code{x}, the horizontal
 coordinates of ray path, \code{z} the vertical coordinates of ray path,
 \code{t} actual travel time of ray in seconds,
 and \code{d} the total distance the ray traveled. Each individual item
 in the output is a list with one entry for each \code{theta0} provided.
}
\description{
Traces the ray of a sound through a varying soundspeed profile
  for a fixed amount of time. Also plots the provided sound speed profile and
  all traces generated. All code here is based on MATLAB code originally
  written by Val Schmidt from the University of New Hampshire
  Val Schmidt (2021). raytrace
  https://www.mathworks.com/matlabcentral/fileexchange/26253-raytrace), MATLAB Central File Exchange. Retrieved June 29, 2021.
}
\examples{

#  Setup the sound speed profile
zz <- seq(from=0, to=5000, by=1)
cc <- 1520 + zz * -.05
cc[751:length(cc)] <- cc[750] + (zz[751:length(zz)] - zz[750])*.014
rt <- raytrace(0, 0, 5, 120, zz, cc, TRUE)

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
