% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OptiSembleForecasting.R
\name{OptiSembleForcasting}
\alias{OptiSembleForcasting}
\title{OptiSembleForecasting}
\usage{
OptiSembleForcasting(TS, Lag, Optimization, Split_ratio)
}
\arguments{
\item{TS}{Time series data with first column as date}

\item{Lag}{Number of lag for modelling}

\item{Optimization}{Optimization technique}

\item{Split_ratio}{Train-Test Split Ration}
}
\value{
\itemize{
  \item SelectedModel: Selected models with weights
  \item Accuracy: Accuracy matrix
  \item TestResults: Final predicted value
}
}
\description{
Optimization Based Ensemble Forecasting Using MCS Algorithm
}
\examples{
\donttest{
library(OptiSembleForecasting)
date<-seq.Date(from = as.Date('2019-09-17'), to = as.Date('2022-09-18'), by = 'days')
value<-rnorm(length(date),100, 50)
data<-cbind(date,value)
fit<-OptiSembleForcasting(TS=data,Lag = 20, Optimization = "ABC",Split_ratio = 0.9)
}
}
\references{
\itemize{
\item Wang, J., Wang, Y., Li, H., Yang, H. and Li, Z. (2022). Ensemble forecasting system based on decomposition-selection-optimization for point and interval carbon price prediction. Applied Mathematical Modelling, doi.org/10.1016/j.apm.2022.09.004.
\item Qu, Z., Li, Y., Jiang, X. and Niu, C. (2022). An innovative ensemble model based on multiple neural networks and a novel heuristic optimization algorithm for COVID-19 forecasting. Expert System Application, doi:10.1016/j.eswa.2022.118746
\item Kriz, K.A. (2019). Ensemble Forecasting. In: Williams, D., Calabrese, T. (eds) The Palgrave Handbook of Government Budget Forecasting. Palgrave Studies in Public Debt, Spending, and Revenue. Palgrave Macmillan, Cham. https://doi.org/10.1007/978-3-030-18195-6_21
}
}
