% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictionQueries.R
\name{getPredictionPerformances}
\alias{getPredictionPerformances}
\title{Extract the model performances}
\usage{
getPredictionPerformances(
  connectionHandler,
  schema,
  plpTablePrefix = "plp_",
  cgTablePrefix = "cg_",
  databaseTable = "database_meta_data",
  databaseTablePrefix = "",
  modelDesignId = NULL,
  developmentDatabaseId = NULL
)
}
\arguments{
\item{connectionHandler}{A connection handler that connects to the database and extracts sql queries.  Create a connection handler via `ResultModelManager::ConnectionHandler$new()`.}

\item{schema}{The result database schema (e.g., 'main' for sqlite)}

\item{plpTablePrefix}{The prefix used for the patient level prediction results tables}

\item{cgTablePrefix}{The prefix used for the cohort generator results tables}

\item{databaseTable}{The name of the table with the database details (default 'database_meta_data')}

\item{databaseTablePrefix}{A prefix to the database table, either '' or 'plp_'}

\item{modelDesignId}{The identifier for a model design  to restrict results to}

\item{developmentDatabaseId}{The identifier for the development database to restrict results to}
}
\value{
Returns a data.frame with the columns:
\itemize{  
 \item{performanceId the unique identifier for the performance}
 \item{modelDesignId the unique identifier for the model design}
 \item{developmentDatabaseId the unique identifier for the database used to develop the model}
 \item{validationDatabaseId the unique identifier for the database used to validate the model}
 \item{developmentTargetId the unique cohort id for the development target population}
 \item{developmentTargetName the name for the development target population}
 \item{developmentOutcomeId the unique cohort id for the development outcome}
 \item{developmentOutcomeName the name for the development outcome}
 \item{developmentDatabase the name for the database used to develop the model}
 \item{validationDatabase the name for the database used to validate the model}
 \item{validationTargetName the name for the validation target population}
 \item{validationOutcomeName the name for the validation outcome}
 \item{timeStamp the date/time when the analysis occurred}
 \item{auroc the test/validation AUROC value for the model}
 \item{auroc95lb the test/validation lower bound of the 95 percent CI AUROC value for the model}
 \item{auroc95ub the test/validation upper bound of the 95 percent CI AUROC value for the model}
 \item{calibrationInLarge the test/validation calibration in the large value for the model}
 \item{eStatistic the test/validation calibration e-statistic value for the model}
 \item{brierScore the test/validation brier value for the model}
 \item{auprc the test/validation discrimination AUPRC value for the model}
 \item{populationSize the test/validation population size used to develop the model}
 \item{outcomeCount the test/validation outcome count used to develop the model}
 \item{evalPercent the percentage of the development data used as the test set}
 \item{outcomePercent the outcome percent in the development data}
 \item{validationTimeAtRisk time at risk for the validation}
 \item{predictionResultType development or validation}
 
}
}
\description{
This function extracts the model performances
}
\details{
Specify the connectionHandler, the resultDatabaseSettings and (optionally) a modelDesignId and/or developmentDatabaseId to restrict models to
}
\examples{
conDet <- getExampleConnectionDetails()

connectionHandler <- ResultModelManager::ConnectionHandler$new(conDet)

perf <- getPredictionPerformances(
  connectionHandler = connectionHandler, 
  schema = 'main'
)

}
\seealso{
Other Prediction: 
\code{\link{getPredictionCohorts}()},
\code{\link{getPredictionDiagnosticTable}()},
\code{\link{getPredictionDiagnostics}()},
\code{\link{getPredictionHyperParamSearch}()},
\code{\link{getPredictionIntercept}()},
\code{\link{getPredictionModelDesigns}()},
\code{\link{getPredictionPerformanceTable}()},
\code{\link{getPredictionTopPredictors}()}
}
\concept{Prediction}
