% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Generate.R
\name{generatePresentation}
\alias{generatePresentation}
\title{generatePresentation}
\usage{
generatePresentation(
  server,
  username,
  password,
  dbms,
  resultsSchema = NULL,
  dbDetails = NULL,
  lead = "add name",
  team = "name 1 name 2",
  trigger = "A signal was found in spontaneous reports",
  safetyQuestion = "",
  objective = "",
  topline1 =
    "Very brief executive summary. You can copy-paste language from the conclusion.",
  topline2 =
    "If an estimation was requested but not feasible, this should be mentioned here.",
  topline3 =
    "If no estimation study was requested, this high-level summary might be skipped.",
  date = as.character(Sys.Date()),
  targetId = 1,
  outcomeIds = 3,
  cohortNames = c("target name", "outcome name"),
  cohortIds = c(1, 3),
  covariateIds = NULL,
  details = list(studyPeriod = "All Time", restrictions = "Age - None"),
  evaluationText = "",
  includeCI = TRUE,
  includeCharacterization = TRUE,
  includeCM = TRUE,
  includeSCCS = TRUE,
  includePLP = TRUE,
  outputLocation,
  outputName = paste0("presentation_", gsub(":", "_", gsub(" ", "_",
    as.character(date()))), ".html"),
  intermediateDir = tempdir()
)
}
\arguments{
\item{server}{The server containing the result database}

\item{username}{The username for an account that can access the result database}

\item{password}{The password for an account that can access the result database}

\item{dbms}{The dbms used to access the result database}

\item{resultsSchema}{The result database schema}

\item{dbDetails}{(Optional) a data.frame with the columns:}

\item{lead}{The name of the presenter}

\item{team}{A vector or all the team members}

\item{trigger}{What triggered the request}

\item{safetyQuestion}{What is the general safety question}

\item{objective}{What is the request/objective of the work.}

\item{topline1}{add a very brief executive summary for the topline slide}

\item{topline2}{add estimation summary here for the topline slide}

\item{topline3}{add any other statement summary here for the topline slide}

\item{date}{The date of the presentation}

\item{targetId}{The cohort definition id for the target cohort}

\item{outcomeIds}{The cohort definition id for the outcome}

\item{cohortNames}{Friendly names for any cohort used in the study}

\item{cohortIds}{The corresponding Ids for the cohortNames}

\item{covariateIds}{A vector of covariateIds to include in the characterization}

\item{details}{a list with the studyPeriod and restrictions}

\item{evaluationText}{a list of bullet points for the evaluation}

\item{includeCI}{Whether to include the cohort incidence slides}

\item{includeCharacterization}{Whether to include the characterization slides}

\item{includeCM}{Whether to include the cohort method slides}

\item{includeSCCS}{Whether to include the self controlled case series slides}

\item{includePLP}{Whether to include the patient level prediction slides}

\item{outputLocation}{The file location and name to save the protocol}

\item{outputName}{The name of the html protocol that is created}

\item{intermediateDir}{The work directory for quarto}
}
\value{
An named R list with the elements 'standard' and 'source'
}
\description{
Generates a presentation from a Strategus result
}
\details{
Specify the connection details to the result database and the schema name
to generate a presentation.
}
\seealso{
Other Reporting: 
\code{\link{generateFullReport}()},
\code{\link{generatePresentationMultiple}()}
}
\concept{Reporting}
