% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{brains_cognitive_matrix}
\alias{brains_cognitive_matrix}
\title{BRAiNS Cohort Cognitive States Matrix}
\format{
A matrix with 6240 observations and 13 variables:
\describe{
  \item{ID}{Integer: Participant identification number}
  \item{visitno}{Integer: Visit number}
  \item{prstate}{Integer: Previous cognitive state}
  \item{custate}{Integer: Current cognitive state}
  \item{bagec}{Integer: Baseline age centered}
  \item{famhx}{Integer: Family history of dementia (0 = No, 1 = Yes)}
  \item{HBP}{Integer: History of high blood pressure (0 = No, 1 = Yes)}
  \item{apoe4}{Integer: APOE \eqn{\varepsilon_4} allele carrier status (0 = Non-carrier, 1 = Carrier)}
  \item{smk1}{Integer: Smoking status indicator 1}
  \item{smk2}{Integer: Smoking status indicator 2}
  \item{smk3}{Integer: Smoking status indicator 3}
  \item{lowed}{Integer: Low education indicator (0 = No, 1 = Yes)}
  \item{headinj}{Integer: History of head injury (0 = No, 1 = Yes)}
}
}
\source{
Data taken from the \pkg{RRMLRfMC} package version 0.4.0. Original study:
University of Kentucky's Alzheimer's Disease Research Center BRAiNS cohort.
}
\usage{
data(brains_cognitive_matrix)
}
\description{
This dataset, \code{brains_cognitive_matrix}, is a matrix containing the states and covariates
of 649 participants enrolled in the BRAiNS cohort at the University of Kentucky's
Alzheimer's Disease Research Center. The data includes longitudinal cognitive assessments
and various health covariates across multiple visits.
}
\details{
The dataset name has been kept as \code{brains_cognitive_matrix} to avoid confusion
with other datasets in the R ecosystem. This naming convention helps distinguish
this dataset as part of the \pkg{NeuroDataSets} package. The suffix \code{matrix} indicates
that the dataset is a matrix. The original content has not been modified.
}
