% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution_plot.R
\name{distribution.plot}
\alias{distribution.plot}
\title{Plots the observed probability for an element against the distribution of the null model}
\usage{
distribution.plot(netfacs.data)
}
\arguments{
\item{netfacs.data}{object resulting from netfacs() function}
}
\value{
Function returns a ggplot showing for each element the distribution of expected probabilities (blue) and the observed probability (black line)
}
\description{
The function takes all single elements in a netfacs object, and plots the distribution of probabilities under the null hypothesis, marking where the observed probability falls
}
\examples{
### how do angry facial expressions differ from non-angry ones?
data(emotions_set)
angry.face <- netfacs(
  data = emotions_set[[1]],
  condition = emotions_set[[2]]$emotion,
  test.condition = "anger",
  ran.trials = 100,
  combination.size = 2
)

# show distribution of AU4
distribution.plot(netfacs.data = angry.face)$"4"
}
