% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate-network.R
\name{pc_estimate_undirected_graph}
\alias{pc_estimate_undirected_graph}
\title{Estimate the undirected graph of the metabolic data.}
\usage{
pc_estimate_undirected_graph(data, alpha = 0.01)
}
\arguments{
\item{data}{Input numeric data that forms the basis of the underlying graph.}

\item{alpha}{Significance level threshold applied to each test to determine
conditional dependence for if an edge exists.}
}
\value{
A \code{pcAlgo} object that contains the DAG skeleton, aka undirected graph.
}
\description{
Uses the PC-algorithm and is mostly a wrapper around \code{\link[pcalg:skeleton]{pcalg::skeleton()}}.
}
\details{
This function estimates the "skeleton of a DAG", meaning a graph without
arrowheads, aka an undirected graph.
The default estimation method used is the "PC-stable" method, which estimates
the \emph{order-independent} skeleton of the DAG, meaning the order of the
variables given does not impact the results (older versions of the algorithm
were order-dependent). The method also assumes no latent variables.

An edge is determined by testing for conditional dependence between two
nodes based on the \code{\link[pcalg:condIndFisherZ]{pcalg::gaussCItest()}}. Conditional \emph{independence} exists
when the nodes have zero partial correlation determined from a p-value based
hypothesis test against the correlation matrix of the data from the nodes.
The estimated edges exists between the \emph{start} and \emph{end} nodes when the
\emph{start} and \emph{end} variables are conditionally dependent given the subset of
remaining variables.
}
\seealso{
The help documentation of \code{\link[pcalg:skeleton]{pcalg::skeleton()}} has more details.
}
\keyword{internal}
