% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecological_indices.R
\name{cal.SRI}
\alias{cal.SRI}
\alias{cal.SRI.data.frame}
\alias{cal.SRI.matrix}
\alias{cal.SRI.default}
\title{Calculate Species Richness Index (SRI)}
\usage{
cal.SRI(data, total.abundance, method = "Margalef", ...)

\method{cal.SRI}{data.frame}(data, total.abundance, method = "Margalef", ...)

\method{cal.SRI}{matrix}(data, total.abundance, method = "Margalef", ...)

\method{cal.SRI}{default}(data, total.abundance, method = "Margalef", ...)
}
\arguments{
\item{data}{\code{data.frame} or \code{matrix}. The nematode abundance table where rows represent samples and columns represent nematode genera.
Each element indicates the count of a specific nematode genus in the corresponding sample. Row names must be sample names, and column names must be nematode genus names.}

\item{total.abundance}{\code{data.frame}. A data frame with sample names as row names and a single column containing the total nematode abundance for each sample.}

\item{method}{The method used to calculate the Species Richness Index. Default is \code{"Margalef"}.
Supported methods are \code{"Margalef"} and \code{"Menhinick"}. Only one method can be specified.
\itemize{
\item \code{"Margalef"}: Margalef's Richness Index, calculated as \eqn{(S - 1) / \ln(N)}.
\item \code{"Menhinick"}: Menhinick's Richness Index, calculated as \eqn{S / \sqrt{N}}.
}}

\item{...}{Additional arguments (currently unused).}
}
\value{
A data frame with two columns:
\item{Sample.ID}{Character vector of sample identifiers (from row names of \code{data})}
\item{SRI}{Species Richness Index for each sample}
}
\description{
This function calculates the Species Richness Index (SRI) for ecological communities.
}
\examples{
# Example with a data frame
df <- data.frame(
  Cephalobus = c(10, NA, 15),
  Caenorhabditis = c(5, 10, NA),
  Pratylenchus = c(8, 12, 10),
  row.names = c("A", "B", "C")
)
abundance <- data.frame(
  abundance = c(100, 150, 120),
  row.names = c("A", "B", "C")
)
cal.SRI(data = df, total.abundance = abundance, method = "Margalef")
}
