% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NMreadSimModTab.R
\name{NMreadSimModTab}
\alias{NMreadSimModTab}
\title{Read simulation results from rds objects and/or NMsimModTab objects}
\usage{
NMreadSimModTab(
  x,
  check.time = FALSE,
  dir.sims,
  wait = FALSE,
  skip.missing = FALSE,
  quiet = FALSE,
  progress,
  read.fst = NULL,
  fast.tables = NULL,
  carry.out = NULL,
  as.fun
)
}
\arguments{
\item{x}{Path to the simulation-specific rds file generated by
NMsim, typically called `NMsim_MetaData.rds`. Can also be a
table of simulation runs as stored in `rds` files by
`NMsim`. The latter should almost never be used.}

\item{check.time}{If found, check whether `fst` file modification
time is newer than `rds` file. The `fst` is generated based on
information in `rds`, but notice that some systems don't
preserve the file modification times. Becasue of that,
`check.time` is `FALSE` by default.}

\item{dir.sims}{By default, `NMreadSim` will use information about
the relative path from the results table file
(`_MetaData.rds`) to the Nonmem simulation results. If these
paths have changed, or for other reasons this doesn't work,
you can use the `dir.sims` argument to specify where to find
the Nonmem simulation results. If an `.fst` file was already
generated and is found next to the `_MetaData.rds`, the path
to the Nonmem simulation results is not used.}

\item{wait}{If simulations seem to not be done yet, wait for them
to finish? If not, an error will be thrown. If you choose to
wait, the risk is results never come. `NMreadSim` will be
waiting for an `lst` file. If Nonmem fails, it will normally
generate an `lst` file. But if `NMTRAN` fails (checks of
control stream prior to running Nonmem), the `lst` file is not
generated.  Default is not to wait.}

\item{skip.missing}{Skip models where results are not available?
Default is `FALSE` meaning an error will be thrown if one or
more models do not have completed results.}

\item{quiet}{Turn off some messages about what is going on?
Default is to report the messages.}

\item{progress}{Track progress? Default is `TRUE` if `quiet` is
FALSE and more than one model is being simulated. The progress
tracking is based on the number of models completed, not the
status of the individual models.}

\item{as.fun}{The default is to return data as a data.frame. Pass
a function (say `tibble::as_tibble`) in as.fun to convert to
something else. If data.tables are wanted, use
as.fun="data.table". The default can be configured using
NMdataConf.}
}
\description{
Read simulation results from rds objects and/or NMsimModTab objects
}
\keyword{internal}
