% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{updateZoomMove}
\alias{updateZoomMove}
\title{Update zoomMove}
\usage{
updateZoomMove(NGLVieweR_proxy, center, zoom, duration = 0, z_offSet = 0)
}
\arguments{
\item{NGLVieweR_proxy}{A NGLVieweR object.}

\item{center}{Target distance of selected atoms/residues.
See the section "selection-language" in the official \href{http://nglviewer.org/ngl/api/}{NGL.js} manual.}

\item{zoom}{Target zoom of selected atoms/residues.
See the section "selection-language" in the official \href{http://nglviewer.org/ngl/api/}{NGL.js} manual.}

\item{duration}{Optional animation time in milliseconds (default = 0).}

\item{z_offSet}{Optional zoom offset value (default = 0).}
}
\value{
API call containing \code{NGLVieweR} \code{id} and list of message parameters.
}
\description{
Add a zoom animation on an existing NGLVieweR object.
}
\examples{
\dontrun{
NGLVieweR_proxy("structure") \%>\% updateZoomMove(center = "200",
                                               zoom = "200",
                                               z_offSet = 80,
                                               duration = 2000)
}

if (interactive()) {
library(shiny)

ui = fluidPage(
  titlePanel("Viewer with API inputs"),
  sidebarLayout(
    sidebarPanel(
      textInput("center", "Center", "200"),
      textInput("zoom", "Zoom", "200"),
      numericInput("zoomOffset", "Zoom offset", 80,0,100),
      numericInput("duration", "Duration", 2000,0,2000),
      actionButton("zoom", "Zoom"),
      actionButton("reset", "Reset")
    ),
    mainPanel(
      NGLVieweROutput("structure")
    )
  )
)
server = function(input, output) {
  output$structure <- renderNGLVieweR({
    NGLVieweR("7CID") \%>\%
      addRepresentation("cartoon",
      param = list(name = "cartoon", color="red")) \%>\%
      addRepresentation("ball+stick",
      param = list(name = "ball+stick", sele="200"))
  })

observeEvent(input$zoom, {
  NGLVieweR_proxy("structure") \%>\%
    updateZoomMove(
      center = isolate(input$center),
      zoom = isolate(input$zoom),
      z_offSet = isolate(input$zoomOffset),
      duration = isolate(input$duration)
    )
})

observeEvent(input$reset, {
  NGLVieweR_proxy("structure") \%>\%
    updateZoomMove(
      center = "*",
      zoom = "*",
      z_offSet = 0,
      duration = 1000
    )
})
}
shinyApp(ui, server)
}
}
\seealso{
\itemize{
\item \code{\link[=zoomMove]{zoomMove()}}
\item \code{\link[=NGLVieweR_example]{NGLVieweR_example()}} See example "updatezoomMove".
}

Other animations: 
\code{\link{setRock}()},
\code{\link{setSpin}()},
\code{\link{updateRock}()},
\code{\link{updateSpin}()},
\code{\link{zoomMove}()}
}
\concept{animations}
