% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot3d.R
\name{plot3d}
\alias{plot3d}
\title{Grafico com tres dimensoes}
\usage{
plot3d(Obj,names = NULL,lab=NULL,title=NULL,cols=c(1,2,3),size=1)
}
\arguments{
\item{Obj}{Objeto criado pelas funcoes `ComponentesPrincipais`, `CoordenadasPrincipais` e `VariaveisCanonicas`.}

\item{names}{Nomes das Variaveis.}

\item{lab}{Nome dos eixos.}

\item{title}{Titulo do grafico.}

\item{cols}{Numeros dos eixos que aparecera no grafico.}

\item{size}{Tamanho das letras.}
}
\value{
Esta funcao retorna um grafico com tres dimensoes.
}
\description{
Esta funcao cria um grafico 3d a partir de escores.
}
\examples{
#####################################
##### Matriz
#################################
data("Dados.MED")
data=as.matrix(Dados.MED[,5:7])
plot3d(Obj = data,names = letters[1:10],
       lab=c("Retencao 75",
             "Retencao 55",
             "Retencao fundo"),size =2 )


#####################################
##### Componentes Principais
#################################
data(Dados.MED)
cp=ComponentesPrincipais(Dados.MED,layout = 11,
                         CorPlot = TRUE,VarCol = "green")
plot3d(Obj = cp,names = letters[1:10],
       lab=c("Principal Component 1",
             "Principal Component 2",
             "Principal Component 3"),size =2 )


#####################################
##### Variaveis  canonicas
#################################
data(Dados.DBC)
VC=VariaveisCanonicas(Dados.DBC,2,CorCol = "red",VarCol = "red")
plot3d(VC)
plot3d(VC,names = paste("Var","1:10"),
       lab=c("Variable component 1",
             "Variable Component 2",
             "Variable Component 3"),size =2 )


#####################################
##### Coordenadas Principais
#################################
data=data("Dados.CAT")
Dist=Distancia(Dados.CAT,Metodo=10)
CO=CoordenadasPrincipais(Dist)
plot3d(Obj = CO,names = letters[1:9],
       lab=c("PCoA 1",
             "PCoA 2",
             "PCoA 3"),size =2 )
}
\references{
PlayList "Curso de Analise Multivariada":
 https://www.youtube.com/playlist?list=PLvth1ZcREyK72M3lFl7kBaHiVh5W53mlR
}
\seealso{
\code{\link{ComponentesPrincipais}}
}
