% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Distributions.R
\name{distr_Uni_EVSK_Th}
\alias{distr_Uni_EVSK_Th}
\title{EVSK Uniform on the sphere}
\usage{
distr_Uni_EVSK_Th(d, nCum = TRUE)
}
\arguments{
\item{d}{dimensions}

\item{nCum}{if it is TRUE then cumulants, skewness an kurtosis are calculated}
}
\value{
The list with  mean vector,  covariance, skewness vector,
total skenwness, kurtosis vector and total kurtosis
}
\description{
Computes the theoretical values of the mean vector,  covariance, skewness vector,
total skenwness, kurtosis vector and total
kurtosis for the Uniform distribution on the sphere.  Note that Skewness is ZERO
}
\references{
Gy.Terdik, Multivariate statistical methods - Going beyond the linear,
Springer 2021 Proposition 5.3 p.297

S. R. Jammalamadaka, E. Taufer, Gy. Terdik. On multivariate
skewness and kurtosis. Sankhya A, 83(2), 607-644.
}
\seealso{
Other Theoretical Moments and Cumulants: 
\code{\link{distr_CFUSN_MomCum_Th}()},
\code{\link{distr_SkewNorm_EVSK_Th}()},
\code{\link{distr_SkewNorm_MomCum_Th}()},
\code{\link{distr_UniAbs_EVSK_Th}()},
\code{\link{distr_Uni_MomCum_Th}()},
\code{\link{distr_ZabsM_MomCum_Th}()},
\code{\link{distr_Zabs_MomCum_Th}()}

Other Multivariate distributions: 
\code{\link{distr_CFUSN_MomCum_Th}()},
\code{\link{distr_CFUSN_Rand}()},
\code{\link{distr_CFUSSD_Rand}()},
\code{\link{distr_SkewNorm_EVSK_Th}()},
\code{\link{distr_SkewNorm_MomCum_Th}()},
\code{\link{distr_SkewNorm_Rand}()},
\code{\link{distr_UniAbs_EVSK_Th}()},
\code{\link{distr_Uni_MomCum_Th}()},
\code{\link{distr_Uni_Rand}()},
\code{\link{distr_ZabsM_MomCum_Th}()},
\code{\link{distr_Zabs_MomCum_Th}()}
}
\concept{Multivariate distributions}
\concept{Theoretical Moments and Cumulants}
