% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MomCums.r
\name{conv_Cum2Mom}
\alias{conv_Cum2Mom}
\title{Convert cumulants to moments (univariate)}
\usage{
conv_Cum2Mom(cum_x)
}
\arguments{
\item{cum_x}{the r-vector of cumulants starting from the first - the mean -
and arriving to the r-th order cumulant}
}
\value{
\code{mu_x} the vector of univariate moments
}
\description{
Obtains a vector of univariate moments from a vector of
univariate cumulants
}
\examples{
cum_x<- c(1,2,3,4)
conv_Cum2Mom(cum_x)

}
\references{
Gy. Terdik, Multivariate statistical methods - going beyond the linear,
Springer 2021.  Section 3.4 formula 3.23
}
\seealso{
Other Moments and cumulants: 
\code{\link{conv_Cum2MomMulti}()},
\code{\link{conv_Mom2CumMulti}()},
\code{\link{conv_Mom2Cum}()}
}
\concept{Moments and cumulants}
