% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hermite.r
\name{Hermite_N_Cov_X1_X2}
\alias{Hermite_N_Cov_X1_X2}
\title{Covariance matrix  for multivariate  T-Hermite polynomials}
\usage{
Hermite_N_Cov_X1_X2(SigX12, N)
}
\arguments{
\item{SigX12}{Covariance matrix  of the Gaussian vectors X1 and X2 respectively
of dimensions d1 and  d2}

\item{N}{Common degree of the multivariate Hermite polynomials}
}
\value{
Covariance matrix of \eqn{H_N(X_1)} and \eqn{H_N(X_2)}
}
\description{
Computation of the covariance matrix between d-variate T-Hermite polynomials
\eqn{H_N(X_1)} and \eqn{H_N(X_2)}.
}
\examples{
Covmat<-matrix(c(1,0.8,0.8,1),2,2)
Cov_X1_X2 <- Hermite_N_Cov_X1_X2(Covmat,3)

}
\references{
Gy.Terdik, Multivariate statistical methods - going beyond the linear,
Springer 2021. (4.59),  (4.66),
}
\seealso{
Other Hermite: 
\code{\link{Hermite_CoeffMulti}()},
\code{\link{Hermite_Coeff}()},
\code{\link{Hermite_Nth}()},
\code{\link{Hermite_Poly_HN_Multi}()},
\code{\link{Hermite_Poly_HN}()},
\code{\link{Hermite_Poly_NH_Inv}()},
\code{\link{Hermite_Poly_NH_Multi_Inv}()}
}
\concept{Hermite}
