% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mplus.R
\name{detectVariables}
\alias{detectVariables}
\title{Automatically detect variables from an Mplus model object}
\usage{
detectVariables(object, quiet = TRUE)
}
\arguments{
\item{object}{An Mplus model object from \code{mplusObject}.#'}

\item{quiet}{optional. If \code{TRUE}, show status messages in the console.}
}
\value{
A vector of variables from the R dataset to use.
}
\description{
This is a function to automatically detect the variables used in an
Mplus model object.
}
\examples{

example1 <- mplusObject(MODEL = "mpg ON wt;",
  rdata = mtcars, autov = FALSE)
example1$usevariables
MplusAutomation:::detectVariables(example1)

example2 <- mplusObject(MODEL = "mpg ON wt;",
  rdata = mtcars, autov = TRUE)
example2$usevariables
example3 <- update(example2,
  MODEL = ~ . + "mpg ON qsec; wt WITH qsec;",
  autov = TRUE)
example3$usevariables
rm(example1, example2, example3)
}
\seealso{
\code{\link{mplusModeler}}, \code{\link{mplusObject}}
}
\author{
Joshua F. Wiley <jwiley.psych@gmail.com>
}
\keyword{interface}
