% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixreg.R
\name{mixregTrim}
\alias{mixregTrim}
\title{Robust Regression Estimator Using Trimmed Likelihood}
\usage{
mixregTrim(x, y, C = 2, keep = 0.95, nstart = 20)
}
\arguments{
\item{x}{an n by p data matrix where n is the number of observations and p is the number of explanatory variables.
The intercept term will automatically be added to the data.}

\item{y}{an n-dimensional vector of response variable.}

\item{C}{number of mixture components. Default is 2.}

\item{keep}{proportion of data to be kept after trimming, ranging from 0 to 1. Default is 0.95.}

\item{nstart}{number of initializations to try. Default is 20.}
}
\value{
A list containing the following elements:
\item{pi}{C-dimensional vector of estimated mixing proportions.}
\item{beta}{C by (p + 1) matrix of estimated regression coefficients.}
\item{sigma}{C-dimensional vector of estimated standard deviations.}
\item{lik}{final likelihood.}
}
\description{
`mixregTrim' is used for robust regression estimation of a mixture model using the trimmed likelihood estimator
(Neykov et al., 2007). It trims the data to reduce the impact of outliers on the model.
}
\examples{
data(tone)
y = tone$tuned
x = tone$stretchratio
k = 160
x[151:k] = 0
y[151:k] = 5
est_TLE = mixregTrim(x, y, 2, 0.95, nstart = 1)
}
\references{
Neykov, N., Filzmoser, P., Dimova, R., and Neytchev, P. (2007). Robust fitting of mixtures using
the trimmed likelihood estimator. Computational Statistics & Data Analysis, 52(1), 299-308.
}
